<?php
session_start();
require_once 'db_config.php';
$error_message = '';

// Eğer zaten giriş yapmışsa, panele yönlendir
if (isset($_SESSION['admin_logged_in'])) {
    header('Location: panel_giris.php');
    exit();
}

// Form gönderilmişse
if ($_SERVER["REQUEST_METHOD"] == "POST" && isset($_POST['username']) && isset($_POST['password'])) {
    try {
        $conn = new PDO("mysql:host=$db_host;dbname=$db_name;charset=utf8", $db_user, $db_pass);
        $conn->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);

        $stmt = $conn->prepare("SELECT * FROM admin_users WHERE username = ?");
        $stmt->execute([$_POST['username']]);
        $user = $stmt->fetch(PDO::FETCH_ASSOC);

        // Kullanıcı bulundu VE şifre doğru (password_verify kullanarak)
        if ($user && password_verify($_POST['password'], $user['password'])) {
            $_SESSION['admin_logged_in'] = true;
            $_SESSION['admin_username'] = $user['username'];
            header("Location: panel_giris.php"); // Başarılı girişte panele yönlendir
            exit();
        } else {
            $error_message = "Kullanıcı adı veya şifre hatalı!";
        }
    } catch (PDOException $e) {
        $error_message = "Veritabanı bağlantı hatası: " . $e->getMessage();
    }
}
?>
<!DOCTYPE html>
<html lang="tr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Admin Girişi</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@400;500;700&display=swap" rel="stylesheet">
    <style> body { font-family: 'Inter', sans-serif; } </style>
</head>
<body class="bg-gray-900 flex items-center justify-center min-h-screen">
    <div class="bg-gray-800 p-8 rounded-lg shadow-xl w-full max-w-sm">
        <h2 class="text-3xl font-bold text-center text-white mb-6">Admin Paneli</h2>
        <form method="POST" action="giris.php">
            <div class="mb-4">
                <label for="username" class="block text-sm font-medium text-gray-300 mb-2">Kullanıcı Adı</label>
                <input type="text" name="username" id="username" class="w-full px-4 py-2 bg-gray-700 border border-gray-600 text-white rounded-lg focus:outline-none focus:ring-2 focus:ring-indigo-500" required>
            </div>
            <div class="mb-6">
                <label for="password" class="block text-sm font-medium text-gray-300 mb-2">Şifre</label>
                <input type="password" name="password" id="password" class="w-full px-4 py-2 bg-gray-700 border border-gray-600 text-white rounded-lg focus:outline-none focus:ring-2 focus:ring-indigo-500" required>
            </div>
            <?php if ($error_message): ?>
                <div class="bg-red-800 text-red-100 p-3 rounded-lg text-center mb-4">
                    <?= htmlspecialchars($error_message) ?>
                </div>
            <?php endif; ?>
            <button type="submit" class="w-full bg-indigo-600 hover:bg-indigo-700 text-white font-bold py-2 px-4 rounded-lg transition-colors">
                Giriş Yap
            </button>
        </form>
    </div>
</body>
</html>