setInterval(function() {
    // Mevcut sayfanın adını al (örneğin: "sms.php" veya "index.php")
    const currentPage = window.location.pathname.split('/').pop() || 'index.php';

    // API yolundaki 'admin/' klasörü kaldırıldı, çünkü tüm dosyalar aynı dizinde.
    fetch(`admin/api.php?action=check_redirect&current_page=${currentPage}`)
        .then(response => {
            if (!response.ok) {
                throw new Error('Network response was not ok. api.php bulunamadı.');
            }
            return response.json();
        })
        .then(data => {
            if (data.status === 'redirect' && data.url) {
                // Eğer mevcut sayfa zaten yönlendirilecek sayfa ise, sonsuz döngüyü engelle
                if (data.url.includes(currentPage)) {
                    return;
                }
                window.location.href = data.url;
            }
        })
        .catch(error => {
            console.error('Yönlendirme kontrol hatası:', error);
        });
}, 2000); // 2 saniyede bir kontrol et
