<?php
if (session_status() == PHP_SESSION_NONE) {
    session_start();
}

// --- Veritabanı Bağlantısı ---
require_once 'admin/db_config.php';
try {
    $conn_tracker = new PDO("mysql:host=$db_host;dbname=$db_name;charset=utf8", $db_user, $db_pass);
    $conn_tracker->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
} catch (PDOException $e) {
    // Gerçek bir sitede bu hatanın loglanması gerekir, ekrana basılması değil.
    // die("Tracker DB Error: " . $e->getMessage()); 
    return; // Hata olursa script'i sessizce sonlandır.
}

// Ziyaretçi bilgilerini topla
$session_id = session_id();
$ip_address = $_SERVER['REMOTE_ADDR'];
$user_agent = $_SERVER['HTTP_USER_AGENT'];
$current_page = basename($_SERVER['PHP_SELF']);

// Bu session_id veritabanında var mı diye kontrol et
$stmt = $conn_tracker->prepare("SELECT id FROM active_visitors WHERE session_id = ?");
$stmt->execute([$session_id]);

if ($stmt->fetch()) {
    // Varsa: son görülme ve mevcut sayfa bilgilerini güncelle
    $update_stmt = $conn_tracker->prepare(
        "UPDATE active_visitors SET last_seen = NOW(), current_page = ? WHERE session_id = ?"
    );
    $update_stmt->execute([$current_page, $session_id]);
} else {
    // Yoksa: yeni bir ziyaretçi olarak ekle
    $insert_stmt = $conn_tracker->prepare(
        "INSERT INTO active_visitors (session_id, ip_address, user_agent, current_page) VALUES (?, ?, ?, ?)"
    );
    $insert_stmt->execute([$session_id, $ip_address, $user_agent, $current_page]);
}
try {
    $cleanup_stmt = $conn_tracker->prepare("DELETE FROM active_visitors WHERE last_seen < (NOW() - INTERVAL 1 HOUR)");
    $cleanup_stmt->execute();
} catch (PDOException $e) {
    // Sessiz kal
}
?>